/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractPickList
extends Composite {
    protected ComboViewer picker;
    protected TableViewer viewer;
    private final Composite composite;
    private final Composite toolBar;
    protected final Button tiAdd;
    protected final Button tiRemove;
    protected final Button tiUp;
    protected final Button tiDown;

    @Deprecated
    public AbstractPickList(Composite parent, int style, List<PickListFeatures> listFeatures, Messages messages, AbstractComponentEditor<?> componentEditor) {
        this(parent, style, listFeatures, componentEditor);
    }

    public AbstractPickList(Composite parent, int style, List<PickListFeatures> listFeatures, AbstractComponentEditor<?> componentEditor) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        if (listFeatures != null && listFeatures.contains((Object)PickListFeatures.NO_GROUP)) {
            this.composite = new Composite((Composite)this, 0);
            this.composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        } else {
            this.composite = new Group((Composite)this, 0);
            this.composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        }
        Composite comp = new Composite(this.composite, 0);
        comp.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        comp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.picker = new ComboViewer(comp, 2060);
        Combo control = this.picker.getCombo();
        GridData gdpicker = new GridData(4, 0x1000000, true, false);
        gdpicker.minimumWidth = 180;
        gdpicker.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gdpicker);
        this.toolBar = new Composite(comp, 0);
        GridLayout layout = GridLayoutFactory.swtDefaults().numColumns(5).spacing(2, 0).equalWidth(true).create();
        if (listFeatures != null && listFeatures.contains((Object)PickListFeatures.NO_PICKER)) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
        }
        this.toolBar.setLayout((Layout)layout);
        this.toolBar.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toolBar.setFont(this.composite.getFont());
        this.picker.addOpenListener(event -> this.addPressed());
        this.tiAdd = new Button(this.toolBar, 8);
        this.tiAdd.setToolTipText(Messages.ModelTooling_Common_AddEllipsis);
        this.tiAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiAdd.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_add"));
        this.tiAdd.setFont(this.getButtonFont());
        this.tiAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.addPressed();
            }
        });
        this.tiRemove = new Button(this.toolBar, 8);
        this.tiRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiRemove.setToolTipText(Messages.ModelTooling_Common_Remove);
        this.tiRemove.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.table_delete"));
        this.tiRemove.setFont(this.getButtonFont());
        this.tiRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPickList.this.removePressed();
            }
        });
        this.tiDown = new Button(this.toolBar, 8);
        this.tiDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiDown.setToolTipText(Messages.ModelTooling_Common_Down);
        this.tiDown.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_down"));
        this.tiDown.setFont(this.getButtonFont());
        this.tiDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable;
                AbstractPickList.this.moveDownPressed();
                boolean bl = enable = AbstractPickList.this.viewer.getTable().getSelectionIndex() + 1 < AbstractPickList.this.getItemCount();
                if (AbstractPickList.this.tiDown.isEnabled() != enable) {
                    AbstractPickList.this.tiDown.setEnabled(enable);
                }
                if (!enable && !AbstractPickList.this.tiUp.isEnabled()) {
                    AbstractPickList.this.tiUp.setEnabled(true);
                }
                AbstractPickList.this.tiDown.setFocus();
            }
        });
        this.tiUp = new Button(this.toolBar, 8);
        this.tiUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.tiUp.setToolTipText(Messages.ModelTooling_Common_Up);
        this.tiUp.setImage(componentEditor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.arrow_up"));
        this.tiUp.setFont(this.getButtonFont());
        this.tiUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable;
                AbstractPickList.this.moveUpPressed();
                boolean bl = enable = AbstractPickList.this.viewer.getTable().getSelectionIndex() > 0;
                if (AbstractPickList.this.tiUp.isEnabled() != enable) {
                    AbstractPickList.this.tiUp.setEnabled(enable);
                }
                if (!enable && !AbstractPickList.this.tiDown.isEnabled()) {
                    AbstractPickList.this.tiDown.setEnabled(true);
                }
                AbstractPickList.this.tiUp.setFocus();
            }
        });
        this.viewer = new TableViewer(this.composite);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.addSelectionChangedListener(event -> this.updateUiState());
        this.updateUiState();
        if (listFeatures != null) {
            if (listFeatures.contains((Object)PickListFeatures.NO_ORDER)) {
                this.tiDown.dispose();
                this.tiUp.dispose();
            }
            if (listFeatures.contains((Object)PickListFeatures.NO_PICKER)) {
                ((GridData)this.picker.getControl().getLayoutData()).exclude = true;
                this.picker.getControl().setVisible(false);
                this.pack();
            }
        }
    }

    protected Font getButtonFont() {
        return this.toolBar.getFont();
    }

    protected void addPressed() {
    }

    protected abstract int getItemCount();

    public TableViewer getList() {
        return this.viewer;
    }

    public void setInput(Object input) {
        this.getPicker().setInput(input);
    }

    public IStructuredSelection getSelection() {
        return this.getPicker().getStructuredSelection();
    }

    public void setSelection(ISelection selection) {
        this.getPicker().setSelection(selection);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.getPicker().setContentProvider(contentProvider);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.getPicker().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    private ComboViewer getPicker() {
        return this.picker;
    }

    public void setComparator(ViewerComparator comparator) {
        this.getPicker().setComparator(comparator);
    }

    protected Composite getToolBar() {
        return this.toolBar;
    }

    protected void moveDownPressed() {
    }

    protected void moveUpPressed() {
    }

    protected void removePressed() {
    }

    public void setText(String text) {
        if (this.composite instanceof Group) {
            ((Group)this.composite).setText(text);
        }
    }

    public void updateUiState() {
        boolean enableUp;
        boolean enableDown;
        boolean enableButtons;
        TableViewer tableViewer = this.getList();
        Table table = tableViewer.getTable();
        int itemCount = this.getItemCount();
        int selectionCount = table.getSelectionCount();
        int selectionIndex = table.getSelectionIndex();
        if (this.tiRemove.isEnabled() != selectionCount > 0) {
            this.tiRemove.setEnabled(selectionCount > 0);
        }
        boolean bl = enableButtons = selectionCount > 0 && itemCount > 1 && selectionCount == 1;
        boolean bl2 = enableButtons ? selectionIndex + 1 < itemCount : (enableDown = false);
        if (!this.tiDown.isDisposed() && this.tiDown.isEnabled() != enableDown) {
            this.tiDown.setEnabled(enableDown);
        }
        boolean bl3 = enableButtons ? selectionIndex > 0 : (enableUp = false);
        if (!this.tiUp.isDisposed() && this.tiUp.isEnabled() != enableUp) {
            this.tiUp.setEnabled(enableUp);
        }
    }

    public static enum PickListFeatures {
        NO_ORDER,
        NO_PICKER,
        NO_GROUP;

    }
}

