/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.ui.util.SortCriterion;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IMemento;

public class TaskComparator
implements Comparator<ITask> {
    private static final String MEMENTO_KEY_SORT = "sort";
    private final MultiValuedMap<String, SortCriterion> sortCriteria;
    private String currentPresentation;
    private final TaskKeyComparator taskKeyComparator = new TaskKeyComparator();
    public static final int CRITERIA_COUNT = SortCriterion.SortKey.values().length - 1;

    public static String[] getSortableFromElement(IRepositoryElement element) {
        ITask task1;
        String[] stringArray = new String[3];
        stringArray[0] = "";
        stringArray[2] = element.getSummary();
        String[] a = stringArray;
        if (element instanceof ITask && (task1 = (ITask)element).getTaskKey() != null) {
            a[1] = task1.getTaskKey();
        }
        return a;
    }

    public TaskComparator() {
        this.sortCriteria = new ArrayListValuedHashMap();
        for (AbstractTaskListPresentation presentation : TaskListView.getPresentations()) {
            String presentationId = presentation.getId();
            int i = 0;
            while (i < CRITERIA_COUNT) {
                this.sortCriteria.put((Object)presentationId, (Object)new SortCriterion());
                ++i;
            }
        }
        for (String id : this.sortCriteria.keySet()) {
            List presentationCriteria = (List)this.sortCriteria.get((Object)id);
            if (id.equals("org.eclipse.mylyn.tasks.ui.scheduled")) {
                ((SortCriterion)presentationCriteria.get(0)).setKey(SortCriterion.SortKey.DUE_DATE);
                ((SortCriterion)presentationCriteria.get(0)).setDirection(1);
                ((SortCriterion)presentationCriteria.get(1)).setKey(SortCriterion.SortKey.SCHEDULED_DATE);
                ((SortCriterion)presentationCriteria.get(1)).setDirection(1);
                ((SortCriterion)presentationCriteria.get(2)).setKey(SortCriterion.SortKey.PRIORITY);
                ((SortCriterion)presentationCriteria.get(3)).setKey(SortCriterion.SortKey.RANK);
                ((SortCriterion)presentationCriteria.get(4)).setKey(SortCriterion.SortKey.DATE_CREATED);
                continue;
            }
            ((SortCriterion)presentationCriteria.get(0)).setKey(SortCriterion.SortKey.PRIORITY);
            ((SortCriterion)presentationCriteria.get(1)).setKey(SortCriterion.SortKey.RANK);
            ((SortCriterion)presentationCriteria.get(2)).setKey(SortCriterion.SortKey.DATE_CREATED);
        }
        this.currentPresentation = "org.eclipse.mylyn.tasks.ui.categorized";
    }

    @Override
    public int compare(ITask element1, ITask element2) {
        for (SortCriterion key : this.getCurrentCriteria()) {
            int result;
            switch (key.getKey()) {
                case DATE_CREATED: {
                    result = this.sortByCreationDate(element1, element2, key.getDirection());
                    break;
                }
                case RANK: {
                    result = this.sortByRank(element1, element2, key.getDirection());
                    break;
                }
                case PRIORITY: {
                    result = this.sortByPriority(element1, element2, key.getDirection());
                    break;
                }
                case SUMMARY: {
                    result = this.sortBySummary(element1, element2, key.getDirection());
                    break;
                }
                case TASK_ID: {
                    result = this.sortByID(element1, element2, key.getDirection());
                    break;
                }
                case TASK_TYPE: {
                    result = this.compare((Comparable)((Object)element1.getTaskKind()), (Object)element2.getTaskKind(), key.getDirection());
                    break;
                }
                case DUE_DATE: {
                    result = this.sortByDueDate(element1, element2, key.getDirection());
                    break;
                }
                case MODIFICATION_DATE: {
                    result = this.sortByModificationDate(element1, element2, key.getDirection());
                    break;
                }
                case SCHEDULED_DATE: {
                    result = this.sortByScheduledDate(element1, element2, key.getDirection());
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public SortCriterion getSortCriterion(int index) {
        return this.getCurrentCriteria().get(index);
    }

    public void restoreState(IMemento memento) {
        if (memento != null) {
            for (String presentationId : this.sortCriteria.keySet()) {
                List criteria = (List)this.sortCriteria.get((Object)presentationId);
                int i = 0;
                while (i < criteria.size()) {
                    IMemento child = memento.getChild(MEMENTO_KEY_SORT + presentationId + i);
                    if (child != null) {
                        ((SortCriterion)criteria.get(i)).restoreState(child);
                    } else if ("org.eclipse.mylyn.tasks.ui.categorized".equals(presentationId) && (child = memento.getChild(MEMENTO_KEY_SORT + i)) != null) {
                        ((SortCriterion)criteria.get(i)).restoreState(child);
                    }
                    ++i;
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            for (String presentationId : this.sortCriteria.keySet()) {
                List criteria = (List)this.sortCriteria.get((Object)presentationId);
                int i = 0;
                while (i < criteria.size()) {
                    IMemento child = memento.createChild(MEMENTO_KEY_SORT + presentationId + i);
                    if (child != null) {
                        ((SortCriterion)criteria.get(i)).saveState(child);
                    }
                    ++i;
                }
            }
        }
    }

    public void presentationChanged(AbstractTaskListPresentation presentation) {
        this.currentPresentation = presentation.getId();
    }

    private List<SortCriterion> getCurrentCriteria() {
        return (List)this.sortCriteria.get((Object)this.currentPresentation);
    }

    private int sortByCreationDate(ITask task1, ITask task2, int sortDirection) {
        Date date1 = task1.getCreationDate();
        Date date2 = task2.getCreationDate();
        return this.compare(date1, date2, sortDirection);
    }

    private int sortByDueDate(ITask task1, ITask task2, int sortDirection) {
        Date date1 = task1.getDueDate();
        Date date2 = task2.getDueDate();
        return this.compare(date1, date2, sortDirection);
    }

    private int sortByModificationDate(ITask task1, ITask task2, int sortDirection) {
        Date date1 = task1.getModificationDate();
        Date date2 = task2.getModificationDate();
        return this.compare(date1, date2, sortDirection);
    }

    private int sortByScheduledDate(ITask task1, ITask task2, int sortDirection) {
        if (task1 instanceof AbstractTask && task2 instanceof AbstractTask) {
            DateRange date1 = ((AbstractTask)task1).getScheduledForDate();
            DateRange date2 = ((AbstractTask)task2).getScheduledForDate();
            return this.compare(date1, date2, sortDirection);
        }
        return 0;
    }

    private int compare(DateRange date1, DateRange date2, int sortDirection) {
        if (date1 == null) {
            return date2 == null ? 0 : 1;
        }
        if (date2 == null) {
            return -1;
        }
        if (date1 instanceof DayDateRange && !(date2 instanceof DayDateRange)) {
            return -1;
        }
        if (date2 instanceof DayDateRange && !(date1 instanceof DayDateRange)) {
            return 1;
        }
        return this.compare(date1.getEndDate(), date2.getEndDate(), sortDirection);
    }

    private <T> int compare(Comparable<T> key1, T key2, int sortDirection) {
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * key1.compareTo(key2);
    }

    private int sortByID(ITask task1, ITask task2, int sortDirection) {
        String key1 = task1.getTaskKey();
        String key2 = task2.getTaskKey();
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * this.taskKeyComparator.compare2(key1, key2);
    }

    private int sortByRank(ITask task1, ITask task2, int sortDirection) {
        if (task1.getConnectorKind() != null && task2.getConnectorKind() != null && task1.getConnectorKind().equals(task2.getConnectorKind()) && task1.getRepositoryUrl() != null && task2.getRepositoryUrl() != null && task1.getRepositoryUrl().equals(task2.getRepositoryUrl())) {
            String rankString1 = task1.getAttribute("task.common.rank");
            String rankString2 = task2.getAttribute("task.common.rank");
            try {
                Double rank1 = rankString1 == null || rankString1.length() == 0 ? 0.0 : Double.valueOf(rankString1);
                Double rank2 = rankString2 == null || rankString2.length() == 0 ? 0.0 : Double.valueOf(rankString2);
                return this.compare(rank1, rank2, sortDirection);
            }
            catch (NumberFormatException e) {
                return this.compare((Comparable)((Object)rankString1), (Object)rankString2, sortDirection);
            }
        }
        return 0;
    }

    private int sortByPriority(ITask task1, ITask task2, int sortDirection) {
        return sortDirection * task1.getPriority().compareToIgnoreCase(task2.getPriority());
    }

    private int sortBySummary(ITask task1, ITask task2, int sortDirection) {
        String key1 = task1.getSummary();
        String key2 = task2.getSummary();
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * key1.compareToIgnoreCase(key2);
    }
}

