/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hor\u00e1rio do Meridiano de Greenwich",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Acre",
               "ACT",
               "Hor\u00e1rio de Ver\u00e3o do Acre",
               "ACST",
               "Hor\u00e1rio do Acre",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Cook",
               "",
               "Meio Hor\u00e1rio de Ver\u00e3o das Ilhas Cook",
               "",
               "Hor\u00e1rio das Ilhas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cuba",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Cuba",
               "",
               "Hor\u00e1rio de Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Hor\u00e1rio do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio do Ir\u00e3",
               "",
            };
        final String[] Niue = new String[] {
               "Hor\u00e1rio de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Peru",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Peru",
               "",
               "Hor\u00e1rio do Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Hor\u00e1rio de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hor\u00e1rio das Ilhas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Chile",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Chile",
               "",
               "Hor\u00e1rio do Chile",
               "",
            };
        final String[] China = new String[] {
               "Hor\u00e1rio Padr\u00e3o da China",
               "",
               "Hor\u00e1rio de Ver\u00e3o da China",
               "",
               "Hor\u00e1rio da China",
               "",
            };
        final String[] Cocos = new String[] {
               "Hor\u00e1rio das Ilhas Coco",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hor\u00e1rio de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00cdndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Jap\u00e3o",
               "",
               "Hor\u00e1rio do Jap\u00e3o",
               "",
            };
        final String[] Korea = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Coreia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Coreia",
               "",
               "Hor\u00e1rio da Coreia",
               "",
            };
        final String[] Nauru = new String[] {
               "Hor\u00e1rio de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hor\u00e1rio do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hor\u00e1rio de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samoa",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Samoa",
               "",
               "Hor\u00e1rio de Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Hor\u00e1rio de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Hor\u00e1rio do Yukon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Alasca",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Alasca",
               "",
               "Hor\u00e1rio do Alasca",
               "",
            };
        final String[] Amazon = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Amazonas",
               "AMT",
               "Hor\u00e1rio de Ver\u00e3o do Amazonas",
               "AMST",
               "Hor\u00e1rio do Amazonas",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Hor\u00e1rio Padr\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio de Ver\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio dos A\u00e7ores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hor\u00e1rio do But\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hor\u00e1rio de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio da Ilha de P\u00e1scoa",
               "",
            };
        final String[] Guyana = new String[] {
               "Hor\u00e1rio da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Israel",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Israel",
               "",
               "Hor\u00e1rio de Israel",
               "",
            };
        final String[] Kosrae = new String[] {
               "Hor\u00e1rio de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hor\u00e1rio de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Moscou",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Moscou",
               "",
               "Hor\u00e1rio de Moscou",
               "",
            };
        final String[] Ponape = new String[] {
               "Hor\u00e1rio de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hor\u00e1rio do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Taipei",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Taipei",
               "",
               "Hor\u00e1rio de Taipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Hor\u00e1rio de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hor\u00e1rio de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hor\u00e1rio de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio da Ar\u00e1bia",
               "",
            };
        final String[] Armenia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio da Arm\u00eania",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hor\u00e1rio da Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hor\u00e1rio Universal Coordenado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hor\u00e1rio do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hor\u00e1rio de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio da Ge\u00f3rgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hor\u00e1rio de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha Norfolk",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ilha Norfolk",
               "",
               "Hor\u00e1rio da Ilha Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hor\u00e1rio de Reuni\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hor\u00e1rio de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hor\u00e1rio das Ilhas Salom\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hor\u00e1rio de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Atl\u00e2ntico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Atl\u00e2ntico",
               "",
               "Hor\u00e1rio do Atl\u00e2ntico",
               "",
            };
        final String[] Brasilia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bras\u00edlia",
               "BRT",
               "Hor\u00e1rio de Ver\u00e3o de Bras\u00edlia",
               "BRST",
               "Hor\u00e1rio de Bras\u00edlia",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Hor\u00e1rio de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio da Col\u00f4mbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio das Ilhas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hor\u00e1rio da Mal\u00e1sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hor\u00e1rio das Ilhas Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paquist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Paquist\u00e3o",
               "",
               "Hor\u00e1rio do Paquist\u00e3o",
               "",
            };
        final String[] Paraguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hor\u00e1rio de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Sacalina",
               "",
            };
        final String[] Suriname = new String[] {
               "Hor\u00e1rio do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Argentina",
               "",
               "Hor\u00e1rio da Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hor\u00e1rio da Ilha Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hor\u00e1rio de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hong Kong",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Hong Kong",
               "",
               "Hor\u00e1rio de Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "Hor\u00e1rio da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hor\u00e1rio do Quirguist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hor\u00e1rio das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Maur\u00edcio",
               "",
            };
        final String[] Singapore = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hor\u00e1rio da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Volgogrado",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Volgogrado",
               "",
               "Hor\u00e1rio de Volgogrado",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio do Arzeibaij\u00e3o",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hor\u00e1rio do Timor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hor\u00e1rio de Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hor\u00e1rio do Tajiquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio do Uzbequist\u00e3o",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hor\u00e1rio do Afeganist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Nova Zel\u00e2ndia",
               "",
               "Hor\u00e1rio da Nova Zel\u00e2ndia",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Filipinas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Filipinas",
               "",
               "Hor\u00e1rio das Filipinas",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hor\u00e1rio do Oceano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hor\u00e1rio das Ilhas da Linha",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Terra Nova",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Terra Nova",
               "",
               "Hor\u00e1rio da Terra Nova",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio do Turcomenist\u00e3o",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hor\u00e1rio da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio da Nova Caled\u00f4nia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hor\u00e1rio da Ge\u00f3rgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ecaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hor\u00e1rio da \u00c1frica Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Hor\u00e1rio da \u00c1frica Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00c1frica Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da \u00c1frica Ocidental",
               "",
               "Hor\u00e1rio da \u00c1frica Ocidental",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Hor\u00e1rio de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Central",
               "",
               "Hor\u00e1rio da Europa Central",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Oriental",
               "",
               "Hor\u00e1rio da Europa Oriental",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Europa Ocidental",
               "",
               "Hor\u00e1rio da Europa Ocidental",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico Mexicano",
               "",
               "Hor\u00e1rio do Pac\u00edfico Mexicano",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Hor\u00e1rio da \u00c1frica do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o Central",
               "",
               "Hor\u00e1rio Central",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Leste",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Leste",
               "",
               "Hor\u00e1rio do Leste",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico",
               "",
               "Hor\u00e1rio do Pac\u00edfico",
               "",
            };
        final String[] French_Southern = new String[] {
               "Hor\u00e1rio dos Territ\u00f3rios Franceses do Sul e Ant\u00e1rtida",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Gilberto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "",
               "Hor\u00e1rio do Hava\u00ed e Ilhas Aleutas",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hor\u00e1rio das Ilhas F\u00eanix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hor\u00e1rio Padr\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hor\u00e1rio Ver\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hor\u00e1rio de S\u00e3o Pedro e Miquel\u00e3o",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Montanhas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Montanhas",
               "",
               "Hor\u00e1rio das Montanhas",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Noroeste do M\u00e9xico",
               "",
               "Hor\u00e1rio do Noroeste do M\u00e9xico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hor\u00e1rio de Papua-Nova Guin\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Central",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Central",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Central",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Oriental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Oriental",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Ocidental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Ocidental",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groel\u00e2ndia Oriental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Groel\u00e2ndia Oriental",
               "",
               "Hor\u00e1rio da Groel\u00e2ndia Oriental",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Groenl\u00e2ndia Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Groenl\u00e2ndia Ocidental",
               "",
               "Hor\u00e1rio da Groenl\u00e2ndia Ocidental",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hor\u00e1rio do Casaquist\u00e3o Ocidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Centro-Ocidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio Padr\u00e3o Irland\u00eas",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "\u00c1den" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u00e3" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3quio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "timezone.excity.Asia/Saigon", "Cidade de Ho Chi Minh" },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "timezone.excity.Asia/Tehran", "Teer\u00e3" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.Etc/Unknown", "Cidade desconhecida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "T\u00fanis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nome" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "Jacarta" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nic\u00f3sia" },
            { "timezone.excity.Asia/Rangoon", "Rangum" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Paris" },
            { "timezone.excity.Europe/Sofia", "S\u00f3fia" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Boise", "Boise" },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.Asia/Ashgabat", "Asgabate" },
            { "timezone.excity.Asia/Calcutta", "Calcut\u00e1" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Duchambe" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "timezone.excity.Asia/Qostanay", "Qostanay" },
            { "timezone.excity.Asia/Sakhalin", "Sacalina" },
            { "timezone.excity.Asia/Shanghai", "Xangai" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "timezone.excity.Europe/Monaco", "M\u00f4naco" },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3via" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Zurique" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nair\u00f3bi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Guiana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9m" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00e3o" },
            { "timezone.excity.Pacific/Easter", "Ilha de P\u00e1scoa" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Taraua" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f3via" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Antigua", "Ant\u00edgua" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Managua", "Man\u00e1gua" },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Atlantic/Canary", "Can\u00e1rias" },
            { "timezone.excity.Atlantic/Faeroe", "Ilhas Faro\u00e9" },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "timezone.excity.Europe/Budapest", "Budapeste" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.Europe/Helsinki", "Helsinque" },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Chatham", "Chatnam" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u00edscio" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Assun\u00e7\u00e3o" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "S\u00e3o Crist\u00f3v\u00e3o" },
            { "timezone.excity.America/St_Lucia", "Santa L\u00facia" },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Europe/Amsterdam", "Amsterd\u00e3" },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e3" },
            { "timezone.excity.Europe/Bucharest", "Bucareste" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcio" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "timezone.excity.America/Guayaquil", "Guaiaquil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizhia" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevid\u00e9u" },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "timezone.excity.America/St_Vincent", "S\u00e3o Vicente" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ecaterimburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Ilha de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Joanesburgo" },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Mexico_City", "Cidade do M\u00e9xico" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "S\u00e3o Bartolomeu" },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Ge\u00f3rgia do Sul" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e3" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota do Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota do Norte" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salen, Dakota do Norte" },
        };
        return data;
    }
}
