/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

public final class ListenerList<L>
implements Iterable<L> {
    private volatile transient L[] listeners = ObjectTools.EMPTY_OBJECT_ARRAY;

    public ListenerList(L listener) {
        this();
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners = new Object[]{listener};
    }

    public ListenerList() {
    }

    @Override
    public Iterator<L> iterator() {
        return IteratorTools.iterator(this.listeners);
    }

    public int size() {
        return this.listeners.length;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public void add(L listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.add_(listener);
    }

    private synchronized void add_(L listener) {
        if (ArrayTools.contains(this.listeners, listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
        this.listeners = ArrayTools.add(this.listeners, listener);
    }

    public void remove(L listener) {
        this.remove_(listener);
    }

    private synchronized void remove_(L listener) {
        int index = ArrayTools.indexOf(this.listeners, listener);
        if (index == -1) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        this.listeners = ArrayTools.removeElementAtIndex(this.listeners, index);
    }

    public synchronized void clear() {
        this.listeners = ObjectTools.EMPTY_OBJECT_ARRAY;
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this.listeners);
    }
}

