/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jem;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;

public final class BeanProxyUtil {

    public static class BeanProxyWrapper {
        private static final IBeanProxy[] NO_ARGS = new IBeanProxy[0];
        private static final IBeanTypeProxy[] NO_ARG_TYPES = new IBeanTypeProxy[0];
        private final IBeanTypeProxy _typeProxy;
        private final IProject _project;
        private IBeanProxy _instance;
        private IType _type;
        private boolean _checkedType;

        public BeanProxyWrapper(IProject project, IBeanTypeProxy typeProxy) {
            this._typeProxy = typeProxy;
            this._project = project;
        }

        public void init() throws ProxyException {
            if (this._instance == null) {
                try {
                    this._instance = this._typeProxy.newInstance();
                }
                catch (ThrowableProxy e) {
                    throw new ProxyException(e);
                }
                catch (NoClassDefFoundError ndfe) {
                    throw new ProxyException(ndfe);
                }
                catch (ExceptionInInitializerError e) {
                    throw new ProxyException(e);
                }
            }
        }

        public void reinit() throws ProxyException {
            this._instance = null;
            this.init();
        }

        public IBeanProxy getInstance() {
            return this._instance;
        }

        public IBeanProxy call(String methodName, IBeanProxy[] args, IBeanTypeProxy[] argTypes) throws ProxyException {
            try {
                IMethodProxy method = this.getMethodProxy(methodName, argTypes);
                if (method != null) {
                    method.setAccessible(true);
                    return method.invoke(this._instance, args);
                }
            }
            catch (ThrowableProxy tp) {
                throw new ProxyException(tp);
            }
            catch (NoClassDefFoundError ndfe) {
                throw new ProxyException(ndfe);
            }
            return null;
        }

        public IBeanProxy call(String methodName) throws ProxyException {
            return this.call(methodName, NO_ARGS, NO_ARG_TYPES);
        }

        public String callStringMethod(String methodName) throws ProxyException {
            IBeanProxy result = this.call(methodName);
            if (result instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)result).stringValue();
            }
            return null;
        }

        public Integer callIntMethod(String methodName) throws ProxyException {
            IBeanProxy result = this.call(methodName, NO_ARGS, NO_ARG_TYPES);
            if (result instanceof IIntegerBeanProxy) {
                return ((IIntegerBeanProxy)result).intValue();
            }
            return null;
        }

        public String getStringFieldValue(String fieldName) throws ProxyException {
            return this.getStringFieldValue(fieldName, this._typeProxy);
        }

        public String getStringFieldValue(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            IBeanProxy value = this.getFieldValue(fieldName, typeProxy);
            if (value instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)value).stringValue();
            }
            return null;
        }

        public IBeanProxy getFieldValue(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            if (!this.hasField(fieldName)) {
                return null;
            }
            try {
                IFieldProxy fieldProxy = typeProxy.getDeclaredFieldProxy(fieldName);
                if (fieldProxy != null) {
                    fieldProxy.setAccessible(true);
                    return fieldProxy.get(this._instance);
                }
            }
            catch (ThrowableProxy e) {
                throw new ProxyException(e);
            }
            catch (NoClassDefFoundError ndfe) {
                throw new ProxyException(ndfe);
            }
            return null;
        }

        public IBeanProxy getFieldValueIncludeParents(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            IBeanTypeProxy curType = typeProxy;
            while (curType != null) {
                IBeanProxy field = this.getFieldValue(fieldName, curType);
                if (field != null) {
                    return field;
                }
                try {
                    IBeanTypeProxy oldType = curType;
                    curType = curType.getSuperBeanTypeProxy();
                    if (oldType != curType) continue;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    curType = null;
                }
            }
            return null;
        }

        public final IBeanProxy getBeanProxy() {
            return this._instance;
        }

        private IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argTypes) {
            IBeanTypeProxy curType = this._typeProxy;
            while (curType != null) {
                IMethodProxy foundMethod;
                IMethodProxy[] declaredMethods = curType.getDeclaredMethods();
                if (declaredMethods != null && (foundMethod = this.findMethodInList(methodName, argTypes, declaredMethods)) != null) {
                    return foundMethod;
                }
                IBeanTypeProxy oldType = curType;
                if (oldType == (curType = this._typeProxy.getSuperBeanTypeProxy())) break;
            }
            return null;
        }

        private IMethodProxy findMethodInList(String methodName, IBeanTypeProxy[] argTypes, IMethodProxy[] listOfMethods) {
            IMethodProxy[] iMethodProxyArray = listOfMethods;
            int n = listOfMethods.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    IBeanTypeProxy[] parameterTypes;
                    IMethodProxy methodProxy = iMethodProxyArray[n2];
                    if (methodName.equals(methodProxy.getName()) && argTypes.length == (parameterTypes = methodProxy.getParameterTypes()).length) {
                        int i = 0;
                        while (i < argTypes.length) {
                            if (argTypes[i].getTypeName().equals(parameterTypes[i].getTypeName())) {
                                ++i;
                                continue;
                            }
                            break block4;
                        }
                        return methodProxy;
                    }
                }
                ++n2;
            }
            return null;
        }

        private boolean hasField(String fieldName) {
            IType type = this.lazilyCalculateType();
            if (type != null) {
                IField field = type.getField(fieldName);
                return field.exists();
            }
            return false;
        }

        private IType lazilyCalculateType() {
            if (!this._checkedType) {
                this._checkedType = true;
                String typeName = this._typeProxy.getTypeName();
                IJavaProject javaProject = JavaCore.create((IProject)this._project);
                if (typeName != null && typeName.startsWith("L")) {
                    this._type = TypeUtil.resolveType((IJavaProject)javaProject, (String)typeName);
                } else {
                    try {
                        this._type = javaProject.findType(typeName);
                    }
                    catch (JavaModelException e) {
                        JSFCorePlugin.log((Exception)((Object)e), "While loading type: " + typeName);
                    }
                }
            }
            return this._type;
        }
    }

    public static class ProxyException
    extends Exception {
        private static final long serialVersionUID = -1526057761795574331L;

        public ProxyException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProxyException(Throwable cause) {
            super(cause);
        }
    }
}

