/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import org.eclipse.datatools.enablement.ibm.util.ModelVersionUtil;

public enum ModelVersion {
    UNKNOWN("http://www.ibm.com/com.ibm.datatools.core/model/data/", "-1", "0", "0", "0"),
    WTP("7", "0", "0", "0"),
    DTP_75("7", "5", "0", "0"),
    DTP_7511("7", "5", "1", "1"),
    DTP_752("7", "5", "2", "0"),
    DISCOVERY_2009_10("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "0", "0", "0"),
    DTP_2009_11("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "0", "0", "1"),
    DTP_2010_03("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "1", "0", "0"),
    DTP_2010_10("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "2", "0", "0"),
    DTP_2011_1Q("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "2", "1", "0"),
    DTP_2011_4Q("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "3", "0", "0"),
    DTP_2011_4Q_PATCH("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "3", "0", "1"),
    DTP_2012_1H("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "4", "0", "0"),
    DTP_2012_2H("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "5", "0", "0"),
    DTP_2013_2Q("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "6", "0", "0"),
    DTP_2013_2H("http://www.ibm.com/com.ibm.datatools.core/model/data/", "1", "7", "0", "0"),
    VALID_PATTERN("http://www.ibm.com/com.ibm.datatools.core/model/data/", "100000", "0", "0", "0");

    public static ModelVersion CURRENT_VERSION;
    private String major;
    private String minor;
    private String service;
    private String modifier;
    private String prefix;
    private String uriString;

    static {
        CURRENT_VERSION = DTP_2013_2H;
    }

    private ModelVersion(String major, String minor, String service, String modifier) {
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.modifier = modifier;
        this.prefix = "http://www.ibm.com/com.ibm.datatools.core/model/";
        this.uriString = String.valueOf(this.prefix) + major + "." + minor + "." + service + "." + modifier;
        ModelVersionUtil.add(this.uriString, this);
    }

    private ModelVersion(String prefix, String major, String minor, String service, String modifier) {
        this.major = major;
        this.minor = minor;
        this.service = service;
        this.modifier = modifier;
        this.prefix = prefix;
        this.uriString = String.valueOf(prefix) + major + "." + minor + "." + service + "." + modifier;
        ModelVersionUtil.add(this.uriString, this);
    }

    public String getURIString() {
        return this.uriString;
    }

    public String getMajor() {
        return this.major;
    }

    public Integer getMajorNumber() {
        return Integer.parseInt(this.major);
    }

    public String getMinor() {
        return this.minor;
    }

    public Integer getMinorNumber() {
        return Integer.parseInt(this.minor);
    }

    public String getService() {
        return this.service;
    }

    public Integer getServiceNumber() {
        return Integer.parseInt(this.service);
    }

    public String getModifier() {
        return this.modifier;
    }

    public Integer getModifierNumber() {
        return Integer.parseInt(this.modifier);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int compareToIgnoresModifier(ModelVersion version) {
        if (version == null) {
            return 1;
        }
        String myNamespacePrefix = this.getPrefix();
        String theirNamespacePrefix = version.getPrefix();
        int myMajor = this.getMajorNumber();
        int theirMajor = version.getMajorNumber();
        int myMinor = this.getMinorNumber();
        int theirMinor = version.getMinorNumber();
        int myService = this.getServiceNumber();
        int theirService = version.getServiceNumber();
        return ModelVersion.compareVersionComponents(myNamespacePrefix, myMajor, myMinor, myService, theirNamespacePrefix, theirMajor, theirMinor, theirService);
    }

    public int compareToIgnoresModifier(String versionNamespace) {
        String[] components = ModelVersionUtil.parseVersionNamespace(versionNamespace);
        if (components == null) {
            throw new IllegalArgumentException();
        }
        return ModelVersion.compareVersionComponents(this.getPrefix(), Integer.parseInt(this.getMajor()), Integer.parseInt(this.getMinor()), Integer.parseInt(this.getService()), components[0], Integer.parseInt(components[1]), Integer.parseInt(components[2]), Integer.parseInt(components[3]));
    }

    public static int compareVersionComponents(String namespacePrefix1, int major1, int minor1, int service1, String namespacePrefix2, int major2, int minor2, int service2) {
        if (namespacePrefix1 == null) {
            throw new IllegalArgumentException();
        }
        if (!namespacePrefix1.equals(namespacePrefix2)) {
            if (namespacePrefix1.equals("http://www.ibm.com/com.ibm.datatools.core/model/") && namespacePrefix2.equals("http://www.ibm.com/com.ibm.datatools.core/model/data/")) {
                return -1;
            }
            if (namespacePrefix1.equals("http://www.ibm.com/com.ibm.datatools.core/model/data/") && namespacePrefix2.equals("http://www.ibm.com/com.ibm.datatools.core/model/")) {
                return 1;
            }
            throw new IllegalArgumentException();
        }
        int majorDifference = major1 - major2;
        int minorDifference = minor1 - minor2;
        int serviceDifference = service1 - service2;
        if (majorDifference < 0) {
            return -1;
        }
        if (majorDifference > 0) {
            return 1;
        }
        if (minorDifference < 0) {
            return -1;
        }
        if (minorDifference > 0) {
            return 1;
        }
        if (serviceDifference < 0) {
            return -1;
        }
        if (serviceDifference > 0) {
            return 1;
        }
        return 0;
    }
}

