/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Attribute;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.EmptyExpression;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.visitor.Visitor;

public class AttributeGroup
extends Statement {
    private final ASTNode.NodeList<Attribute> attributes = new ASTNode.NodeList(ATTRIBUTES_PROPERTY);
    private EmptyExpression emptyPart;
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(AttributeGroup.class, "attributes", Attribute.class, false);
    public static final ChildPropertyDescriptor EMPTY_PART_PROPERTY = new ChildPropertyDescriptor(UseStatement.class, "emptyPart", EmptyExpression.class, false, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(2);
        properyList.add(ATTRIBUTES_PROPERTY);
        properyList.add(EMPTY_PART_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public AttributeGroup(AST ast) {
        super(ast);
    }

    public AttributeGroup(int start, int end, AST ast, List<Attribute> attributes, EmptyExpression empty) {
        super(start, end, ast);
        if (attributes == null || attributes.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (Attribute a : attributes) {
            this.attributes.add(a);
        }
        this.setEmptyPart(empty);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.attributes) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.attributes) {
            aSTNode.traverseTopDown(visitor);
        }
        if (this.emptyPart() != null) {
            this.emptyPart().traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.attributes) {
            aSTNode.traverseBottomUp(visitor);
        }
        if (this.emptyPart() != null) {
            this.emptyPart().traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<AttributeGroup");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (Attribute part : this.attributes) {
            part.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        if (this.emptyPart() != null) {
            this.emptyPart().toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</AttributeGroup>");
    }

    @Override
    public int getType() {
        return 83;
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public EmptyExpression emptyPart() {
        return this.emptyPart;
    }

    public void setEmptyPart(EmptyExpression emptyPart) {
        EmptyExpression oldChild = this.emptyPart;
        this.preReplaceChild(oldChild, emptyPart, EMPTY_PART_PROPERTY);
        this.emptyPart = emptyPart;
        this.postReplaceChild(oldChild, emptyPart, EMPTY_PART_PROPERTY);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ATTRIBUTES_PROPERTY) {
            return this.attributes();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EMPTY_PART_PROPERTY) {
            if (get) {
                return this.emptyPart();
            }
            this.setEmptyPart((EmptyExpression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Attribute> parts = ASTNode.copySubtrees(target, this.attributes());
        EmptyExpression empty = ASTNode.copySubtree(target, this.emptyPart());
        return new AttributeGroup(this.getStart(), this.getEnd(), target, parts, empty);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

