/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.contentmodel.PropCMSubProperty;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundPositionXSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundPositionYSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BackgroundShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderBottomShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderColorShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderLeftShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderRightShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderStyleShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderTopShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.BorderWidthShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipBottomSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipLeftSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipRightSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ClipTopSubStyleAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.FontShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ICSS2Properties;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ISubPropertyAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ListStyleShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.MarginShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.PaddingShorthandAdapter;
import org.eclipse.wst.css.core.internal.util.declaration.ValueData;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyContext
implements ICSS2Properties {
    protected Hashtable fProperties = new Hashtable();
    HashSet fModified = null;
    private static Hashtable subPropertyAdapters;
    private static Hashtable shorthandAdapters;

    public CSSPropertyContext() {
        CSSPropertyContext.initShorthandAdapters();
        CSSPropertyContext.initSubPropertyAdapters();
    }

    public CSSPropertyContext(ICSSStyleDeclaration decl) {
        CSSPropertyContext.initShorthandAdapters();
        CSSPropertyContext.initSubPropertyAdapters();
        this.initialize(decl);
    }

    @Override
    public void applyFull(ICSSStyleDeclaration decl) {
        if (decl == null) {
            return;
        }
        Enumeration keys = this.fProperties.keys();
        while (keys.hasMoreElements()) {
            String value;
            Object key = keys.nextElement();
            Object val = this.fProperties.get(key);
            String string = value = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : val.toString();
            if (value == null || value.length() <= 0) {
                decl.removeProperty(key.toString());
                continue;
            }
            decl.setProperty(key.toString(), value.trim(), val instanceof ValueData && ((ValueData)val).important ? "!important" : "");
        }
    }

    @Override
    public void applyModified(ICSSStyleDeclaration decl) {
        if (decl == null || this.fModified == null) {
            return;
        }
        for (Object key : this.fModified) {
            String value;
            Object val = this.fProperties.get(key);
            String string = val instanceof ICSSValue ? ((ICSSValue)val).getCSSValueText() : (value = val != null ? val.toString() : null);
            if (value == null || value.length() <= 0) {
                decl.removeProperty(key.toString());
                continue;
            }
            decl.setProperty(key.toString(), value.trim(), val instanceof ValueData && ((ValueData)val).important ? "!important" : "");
        }
    }

    public Object clone() {
        CSSPropertyContext clone = new CSSPropertyContext();
        clone.fModified = this.fModified != null ? (HashSet)this.fModified.clone() : null;
        clone.fProperties = (Hashtable)this.fProperties.clone();
        return clone;
    }

    protected static void expandToLeaf(PropCMProperty prop, String value, CSSPropertyContext foreign) {
        if (value != null && value.trim().length() > 0) {
            IShorthandAdapter adapter = (IShorthandAdapter)shorthandAdapters.get(prop);
            if (adapter != null) {
                adapter.expand(value, foreign);
                foreign.set(prop.getName(), "");
                int i = 0;
                while (i < prop.getNumChild()) {
                    Object obj = prop.getChildAt(i);
                    if (obj instanceof PropCMProperty && !(obj instanceof PropCMSubProperty)) {
                        PropCMProperty expandedProp = (PropCMProperty)obj;
                        value = foreign.get(expandedProp.getName());
                        CSSPropertyContext.expandToLeaf(expandedProp, value, foreign);
                    }
                    ++i;
                }
            } else if (!value.equals(foreign.get(prop.getName()))) {
                foreign.set(prop.getName(), value);
            }
        }
    }

    @Override
    public String get(PropCMProperty prop) {
        ISubPropertyAdapter adapter;
        if (prop instanceof PropCMSubProperty && (adapter = (ISubPropertyAdapter)subPropertyAdapters.get(prop.getName())) != null) {
            return adapter.get(this);
        }
        String str = this.get(prop.getName());
        if ((str == null || str.length() == 0) && prop.getShorthandContainerCount() > 0) {
            int i = 0;
            while (i < prop.getShorthandContainerCount()) {
                IShorthandAdapter adapter2;
                PropCMProperty propParent = prop.shorthandContainerAt(i);
                String strParent = this.get(propParent);
                if (strParent != null && strParent.trim().length() > 0 && (adapter2 = (IShorthandAdapter)shorthandAdapters.get(propParent)) != null) {
                    String extractedValue = adapter2.extract(strParent, prop);
                    return extractedValue != null ? extractedValue : "";
                }
                ++i;
            }
        }
        return str;
    }

    protected String get(String propName) {
        String str = null;
        Object obj = this.fProperties.get(propName);
        if (obj != null) {
            str = obj instanceof ICSSValue ? ((ICSSValue)obj).getCSSValueText() : obj.toString();
        }
        return str != null ? str : "";
    }

    @Override
    public String getAzimuth() {
        return this.get(PropCMProperty.getInstanceOf("azimuth"));
    }

    @Override
    public String getBackground() {
        return this.get(PropCMProperty.getInstanceOf("background"));
    }

    @Override
    public String getBackgroundAttachment() {
        return this.get(PropCMProperty.getInstanceOf("background-attachment"));
    }

    @Override
    public String getBackgroundColor() {
        return this.get(PropCMProperty.getInstanceOf("background-color"));
    }

    @Override
    public String getBackgroundImage() {
        return this.get(PropCMProperty.getInstanceOf("background-image"));
    }

    @Override
    public String getBackgroundPosition() {
        return this.get(PropCMProperty.getInstanceOf("background-position"));
    }

    @Override
    public String getBackgroundPositionX() {
        return this.get(PropCMSubProperty.getInstanceOf("background-positionH"));
    }

    @Override
    public String getBackgroundPositionY() {
        return this.get(PropCMSubProperty.getInstanceOf("background-positionV"));
    }

    @Override
    public String getBackgroundRepeat() {
        return this.get(PropCMProperty.getInstanceOf("background-repeat"));
    }

    @Override
    public String getBorder() {
        return this.get(PropCMProperty.getInstanceOf("border"));
    }

    @Override
    public String getBorderBottom() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom"));
    }

    @Override
    public String getBorderBottomColor() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-color"));
    }

    @Override
    public String getBorderBottomStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-style"));
    }

    @Override
    public String getBorderBottomWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-bottom-width"));
    }

    @Override
    public String getBorderCollapse() {
        return this.get(PropCMProperty.getInstanceOf("border-collapse"));
    }

    @Override
    public String getBorderColor() {
        return this.get(PropCMProperty.getInstanceOf("border-color"));
    }

    @Override
    public String getBorderLeft() {
        return this.get(PropCMProperty.getInstanceOf("border-left"));
    }

    @Override
    public String getBorderLeftColor() {
        return this.get(PropCMProperty.getInstanceOf("border-left-color"));
    }

    @Override
    public String getBorderLeftStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-left-style"));
    }

    @Override
    public String getBorderLeftWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-left-width"));
    }

    @Override
    public String getBorderRight() {
        return this.get(PropCMProperty.getInstanceOf("border-right"));
    }

    @Override
    public String getBorderRightColor() {
        return this.get(PropCMProperty.getInstanceOf("border-right-color"));
    }

    @Override
    public String getBorderRightStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-right-style"));
    }

    @Override
    public String getBorderRightWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-right-width"));
    }

    @Override
    public String getBorderSpacing() {
        return this.get(PropCMProperty.getInstanceOf("border-spacing"));
    }

    @Override
    public String getBorderStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-style"));
    }

    @Override
    public String getBorderTop() {
        return this.get(PropCMProperty.getInstanceOf("border-top"));
    }

    @Override
    public String getBorderTopColor() {
        return this.get(PropCMProperty.getInstanceOf("border-top-color"));
    }

    @Override
    public String getBorderTopStyle() {
        return this.get(PropCMProperty.getInstanceOf("border-top-style"));
    }

    @Override
    public String getBorderTopWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-top-width"));
    }

    @Override
    public String getBorderWidth() {
        return this.get(PropCMProperty.getInstanceOf("border-width"));
    }

    @Override
    public String getBottom() {
        return this.get(PropCMProperty.getInstanceOf("bottom"));
    }

    @Override
    public String getCaptionSide() {
        return this.get(PropCMProperty.getInstanceOf("caption-side"));
    }

    @Override
    public String getClear() {
        return this.get(PropCMProperty.getInstanceOf("clear"));
    }

    @Override
    public String getClip() {
        return this.get(PropCMProperty.getInstanceOf("clip"));
    }

    @Override
    public String getClipBottom() {
        return this.get(PropCMSubProperty.getInstanceOf("clipBottom"));
    }

    @Override
    public String getClipLeft() {
        return this.get(PropCMSubProperty.getInstanceOf("clipLeft"));
    }

    @Override
    public String getClipRight() {
        return this.get(PropCMSubProperty.getInstanceOf("clipRight"));
    }

    @Override
    public String getClipTop() {
        return this.get(PropCMSubProperty.getInstanceOf("clipTop"));
    }

    @Override
    public String getColor() {
        return this.get(PropCMProperty.getInstanceOf("color"));
    }

    @Override
    public String getContent() {
        return this.get(PropCMProperty.getInstanceOf("content"));
    }

    @Override
    public String getCounterIncrement() {
        return this.get(PropCMProperty.getInstanceOf("counter-increment"));
    }

    @Override
    public String getCounterReset() {
        return this.get(PropCMProperty.getInstanceOf("counter-reset"));
    }

    @Override
    public String getCssFloat() {
        return this.get(PropCMProperty.getInstanceOf("float"));
    }

    @Override
    public String getCue() {
        return this.get(PropCMProperty.getInstanceOf("cue"));
    }

    @Override
    public String getCueAfter() {
        return this.get(PropCMProperty.getInstanceOf("cue-after"));
    }

    @Override
    public String getCueBefore() {
        return this.get(PropCMProperty.getInstanceOf("cue-before"));
    }

    @Override
    public String getCursor() {
        return this.get(PropCMProperty.getInstanceOf("cursor"));
    }

    @Override
    public String getDirection() {
        return this.get(PropCMProperty.getInstanceOf("direction"));
    }

    @Override
    public String getDisplay() {
        return this.get(PropCMProperty.getInstanceOf("display"));
    }

    @Override
    public String getElevation() {
        return this.get(PropCMProperty.getInstanceOf("elevation"));
    }

    @Override
    public String getEmptyCells() {
        return this.get(PropCMProperty.getInstanceOf("empty-cells"));
    }

    @Override
    public String getFont() {
        return this.get(PropCMProperty.getInstanceOf("font"));
    }

    @Override
    public String getFontFamily() {
        return this.get(PropCMProperty.getInstanceOf("font-family"));
    }

    @Override
    public String getFontSize() {
        return this.get(PropCMProperty.getInstanceOf("font-size"));
    }

    @Override
    public String getFontSizeAdjust() {
        return this.get(PropCMProperty.getInstanceOf("font-size-adjust"));
    }

    @Override
    public String getFontStretch() {
        return this.get(PropCMProperty.getInstanceOf("font-stretch"));
    }

    @Override
    public String getFontStyle() {
        return this.get(PropCMProperty.getInstanceOf("font-style"));
    }

    @Override
    public String getFontVariant() {
        return this.get(PropCMProperty.getInstanceOf("font-variant"));
    }

    @Override
    public String getFontWeight() {
        return this.get(PropCMProperty.getInstanceOf("font-weight"));
    }

    @Override
    public String getHeight() {
        return this.get(PropCMProperty.getInstanceOf("height"));
    }

    @Override
    public String getLeft() {
        return this.get(PropCMProperty.getInstanceOf("left"));
    }

    @Override
    public String getLetterSpacing() {
        return this.get(PropCMProperty.getInstanceOf("letter-spacing"));
    }

    @Override
    public String getLineHeight() {
        return this.get(PropCMProperty.getInstanceOf("line-height"));
    }

    @Override
    public String getListStyle() {
        return this.get(PropCMProperty.getInstanceOf("list-style"));
    }

    @Override
    public String getListStyleImage() {
        return this.get(PropCMProperty.getInstanceOf("list-style-image"));
    }

    @Override
    public String getListStylePosition() {
        return this.get(PropCMProperty.getInstanceOf("list-style-position"));
    }

    @Override
    public String getListStyleType() {
        return this.get(PropCMProperty.getInstanceOf("list-style-type"));
    }

    @Override
    public String getMargin() {
        return this.get(PropCMProperty.getInstanceOf("margin"));
    }

    @Override
    public String getMarginBottom() {
        return this.get(PropCMProperty.getInstanceOf("margin-bottom"));
    }

    @Override
    public String getMarginLeft() {
        return this.get(PropCMProperty.getInstanceOf("margin-left"));
    }

    @Override
    public String getMarginRight() {
        return this.get(PropCMProperty.getInstanceOf("margin-right"));
    }

    @Override
    public String getMarginTop() {
        return this.get(PropCMProperty.getInstanceOf("margin-top"));
    }

    @Override
    public String getMarkerOffset() {
        return this.get(PropCMProperty.getInstanceOf("marker-offset"));
    }

    @Override
    public String getMarks() {
        return this.get(PropCMProperty.getInstanceOf("marks"));
    }

    @Override
    public String getMaxHeight() {
        return this.get(PropCMProperty.getInstanceOf("max-height"));
    }

    @Override
    public String getMaxWidth() {
        return this.get(PropCMProperty.getInstanceOf("max-width"));
    }

    @Override
    public String getMinHeight() {
        return this.get(PropCMProperty.getInstanceOf("min-height"));
    }

    @Override
    public String getMinWidth() {
        return this.get(PropCMProperty.getInstanceOf("min-width"));
    }

    @Override
    public String getOrphans() {
        return this.get(PropCMProperty.getInstanceOf("orphans"));
    }

    @Override
    public String getOutline() {
        return this.get(PropCMProperty.getInstanceOf("outline"));
    }

    @Override
    public String getOutlineColor() {
        return this.get(PropCMProperty.getInstanceOf("outline-color"));
    }

    @Override
    public String getOutlineStyle() {
        return this.get(PropCMProperty.getInstanceOf("outline-style"));
    }

    @Override
    public String getOutlineWidth() {
        return this.get(PropCMProperty.getInstanceOf("outline-width"));
    }

    @Override
    public String getOverflow() {
        return this.get(PropCMProperty.getInstanceOf("overflow"));
    }

    @Override
    public String getPadding() {
        return this.get(PropCMProperty.getInstanceOf("padding"));
    }

    @Override
    public String getPaddingBottom() {
        return this.get(PropCMProperty.getInstanceOf("padding-bottom"));
    }

    @Override
    public String getPaddingLeft() {
        return this.get(PropCMProperty.getInstanceOf("padding-left"));
    }

    @Override
    public String getPaddingRight() {
        return this.get(PropCMProperty.getInstanceOf("padding-right"));
    }

    @Override
    public String getPaddingTop() {
        return this.get(PropCMProperty.getInstanceOf("padding-top"));
    }

    @Override
    public String getPage() {
        return this.get(PropCMProperty.getInstanceOf("page"));
    }

    @Override
    public String getPageBreakAfter() {
        return this.get(PropCMProperty.getInstanceOf("page-break-after"));
    }

    @Override
    public String getPageBreakBefore() {
        return this.get(PropCMProperty.getInstanceOf("page-break-before"));
    }

    @Override
    public String getPageBreakInside() {
        return this.get(PropCMProperty.getInstanceOf("page-break-inside"));
    }

    @Override
    public String getPause() {
        return this.get(PropCMProperty.getInstanceOf("pause"));
    }

    @Override
    public String getPauseAfter() {
        return this.get(PropCMProperty.getInstanceOf("pause-after"));
    }

    @Override
    public String getPauseBefore() {
        return this.get(PropCMProperty.getInstanceOf("pause-before"));
    }

    @Override
    public String getPitch() {
        return this.get(PropCMProperty.getInstanceOf("pitch"));
    }

    @Override
    public String getPitchRange() {
        return this.get(PropCMProperty.getInstanceOf("pitch-range"));
    }

    @Override
    public String getPlayDuring() {
        return this.get(PropCMProperty.getInstanceOf("play-during"));
    }

    @Override
    public String getPosition() {
        return this.get(PropCMProperty.getInstanceOf("position"));
    }

    @Override
    public String getQuotes() {
        return this.get(PropCMProperty.getInstanceOf("quotes"));
    }

    @Override
    public String getRichness() {
        return this.get(PropCMProperty.getInstanceOf("richness"));
    }

    @Override
    public String getRight() {
        return this.get(PropCMProperty.getInstanceOf("right"));
    }

    public static IShorthandAdapter getShorthandAdapter(PropCMProperty prop) {
        return (IShorthandAdapter)shorthandAdapters.get(prop);
    }

    @Override
    public String getSize() {
        return this.get(PropCMProperty.getInstanceOf("size"));
    }

    @Override
    public String getSpeak() {
        return this.get(PropCMProperty.getInstanceOf("speak"));
    }

    @Override
    public String getSpeakHeader() {
        return this.get(PropCMProperty.getInstanceOf("speak-header"));
    }

    @Override
    public String getSpeakNumeral() {
        return this.get(PropCMProperty.getInstanceOf("speak-numeral"));
    }

    @Override
    public String getSpeakPunctuation() {
        return this.get(PropCMProperty.getInstanceOf("speak-punctuation"));
    }

    @Override
    public String getSpeechRate() {
        return this.get(PropCMProperty.getInstanceOf("speech-rate"));
    }

    @Override
    public String getStress() {
        return this.get(PropCMProperty.getInstanceOf("stress"));
    }

    @Override
    public String getTableLayout() {
        return this.get(PropCMProperty.getInstanceOf("table-layout"));
    }

    @Override
    public String getTextAlign() {
        return this.get(PropCMProperty.getInstanceOf("text-align"));
    }

    @Override
    public String getTextDecoration() {
        return this.get(PropCMProperty.getInstanceOf("text-decoration"));
    }

    @Override
    public String getTextIndent() {
        return this.get(PropCMProperty.getInstanceOf("text-indent"));
    }

    @Override
    public String getTextShadow() {
        return this.get(PropCMProperty.getInstanceOf("text-shadow"));
    }

    @Override
    public String getTextTransform() {
        return this.get(PropCMProperty.getInstanceOf("text-transform"));
    }

    @Override
    public String getTop() {
        return this.get(PropCMProperty.getInstanceOf("top"));
    }

    @Override
    public String getUnicodeBidi() {
        return this.get(PropCMProperty.getInstanceOf("unicode-bidi"));
    }

    @Override
    public String getVerticalAlign() {
        return this.get(PropCMProperty.getInstanceOf("vertical-align"));
    }

    @Override
    public String getVisibility() {
        return this.get(PropCMProperty.getInstanceOf("visibility"));
    }

    @Override
    public String getVoiceFamily() {
        return this.get(PropCMProperty.getInstanceOf("voice-family"));
    }

    @Override
    public String getVolume() {
        return this.get(PropCMProperty.getInstanceOf("volume"));
    }

    @Override
    public String getWhiteSpace() {
        return this.get(PropCMProperty.getInstanceOf("white-space"));
    }

    @Override
    public String getWidows() {
        return this.get(PropCMProperty.getInstanceOf("widows"));
    }

    @Override
    public String getWidth() {
        return this.get(PropCMProperty.getInstanceOf("width"));
    }

    @Override
    public String getWordSpacing() {
        return this.get(PropCMProperty.getInstanceOf("word-spacing"));
    }

    @Override
    public String getZIndex() {
        return this.get(PropCMProperty.getInstanceOf("z-index"));
    }

    public void initialize(ICSSStyleDeclaration decl) {
        this.fProperties.clear();
        if (this.fModified != null) {
            this.fModified.clear();
        }
        if (decl == null) {
            return;
        }
        int nProperties = decl.getLength();
        int i = 0;
        while (i < nProperties) {
            CSSValue val;
            String propN;
            String propName = decl.item(i);
            if (propName != null && (propN = propName.trim().toLowerCase()).length() != 0 && (val = decl.getPropertyCSSValue(propName)) != null) {
                this.fProperties.put(propN, val);
            }
            ++i;
        }
    }

    static void initShorthandAdapters() {
        if (shorthandAdapters == null) {
            shorthandAdapters = new Hashtable();
            shorthandAdapters.put(PropCMProperty.getInstanceOf("background"), new BackgroundShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border"), new BorderShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-color"), new BorderColorShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-style"), new BorderStyleShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-width"), new BorderWidthShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-top"), new BorderTopShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-right"), new BorderRightShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-bottom"), new BorderBottomShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("border-left"), new BorderLeftShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("font"), new FontShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("list-style"), new ListStyleShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("margin"), new MarginShorthandAdapter());
            shorthandAdapters.put(PropCMProperty.getInstanceOf("padding"), new PaddingShorthandAdapter());
        }
    }

    static void initSubPropertyAdapters() {
        if (subPropertyAdapters == null) {
            subPropertyAdapters = new Hashtable();
            subPropertyAdapters.put("background-positionH", new BackgroundPositionXSubStyleAdapter());
            subPropertyAdapters.put("background-positionV", new BackgroundPositionYSubStyleAdapter());
            subPropertyAdapters.put("clipTop", new ClipTopSubStyleAdapter());
            subPropertyAdapters.put("clipRight", new ClipRightSubStyleAdapter());
            subPropertyAdapters.put("clipBottom", new ClipBottomSubStyleAdapter());
            subPropertyAdapters.put("clipLeft", new ClipLeftSubStyleAdapter());
        }
    }

    @Override
    public boolean isModified() {
        return this.fModified != null && this.fModified.size() != 0;
    }

    @Override
    public Enumeration properties() {
        return this.fProperties.keys();
    }

    @Override
    public Iterator propertiesModified() {
        if (this.fModified != null) {
            return ((Collection)this.fModified.clone()).iterator();
        }
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected void recursiveExtract(PropCMProperty prop, CSSPropertyContext foreign) {
        IShorthandAdapter adapter;
        int i = 0;
        while (i < prop.getShorthandContainerCount()) {
            this.recursiveExtract(prop.shorthandContainerAt(i), foreign);
            ++i;
        }
        String str = this.get(prop.getName());
        if (str == null || str.trim().length() == 0) {
            str = foreign.get(prop.getName());
        }
        if (str != null && str.trim().length() > 0 && (adapter = (IShorthandAdapter)shorthandAdapters.get(prop)) != null) {
            adapter.expand(str, foreign);
            foreign.set(prop.getName(), "");
        }
    }

    protected void removeDescendants(PropCMProperty prop) {
        if (prop.isShorthand()) {
            int n = prop.getNumChild();
            int i = 0;
            while (i < n) {
                Object obj = prop.getChildAt(i);
                if (obj instanceof PropCMProperty) {
                    this.removeDescendants((PropCMProperty)obj);
                    String str = this.get(obj.toString());
                    if (str != null && str.length() > 0) {
                        this.set(obj.toString(), "");
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void resetModified() {
        if (this.fModified != null) {
            this.fModified.clear();
        }
    }

    @Override
    public void set(PropCMProperty prop, String value) throws DOMException {
        ISubPropertyAdapter adapter;
        if (prop instanceof PropCMSubProperty && (adapter = (ISubPropertyAdapter)subPropertyAdapters.get(prop.getName())) != null) {
            adapter.set(this, value);
            return;
        }
        if (prop.getShorthandContainerCount() > 0) {
            CSSPropertyContext context = new CSSPropertyContext();
            int i = 0;
            while (i < prop.getShorthandContainerCount()) {
                this.recursiveExtract(prop.shorthandContainerAt(i), context);
                ++i;
            }
            Enumeration properties = context.properties();
            while (properties.hasMoreElements()) {
                String propForeign = properties.nextElement().toString();
                this.set(propForeign, context.get(propForeign));
            }
        }
        this.removeDescendants(prop);
        this.set(prop.getName(), value);
    }

    protected void set(String propName, String value) throws DOMException {
        String key = propName;
        if (value == null) {
            this.fProperties.remove(key);
        } else {
            this.fProperties.put(key, value);
        }
        if (this.fModified == null) {
            this.fModified = new HashSet();
        }
        this.fModified.add(key);
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("azimuth"), azimuth);
    }

    @Override
    public void setBackground(String background) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background"), background);
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-attachment"), backgroundAttachment);
    }

    @Override
    public void setBackgroundColor(String backgroundColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-color"), backgroundColor);
    }

    @Override
    public void setBackgroundImage(String backgroundImage) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-image"), backgroundImage);
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-position"), backgroundPosition);
    }

    @Override
    public void setBackgroundPositionX(String backgroundPositionX) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("background-positionH"), backgroundPositionX);
    }

    @Override
    public void setBackgroundPositionY(String backgroundPositionY) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("background-positionV"), backgroundPositionY);
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("background-repeat"), backgroundRepeat);
    }

    @Override
    public void setBorder(String border) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border"), border);
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom"), borderBottom);
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-color"), borderBottomColor);
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-style"), borderBottomStyle);
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-bottom-width"), borderBottomWidth);
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-collapse"), borderCollapse);
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-color"), borderColor);
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left"), borderLeft);
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-color"), borderLeftColor);
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-style"), borderLeftStyle);
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-left-width"), borderLeftWidth);
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right"), borderRight);
    }

    @Override
    public void setBorderRightColor(String borderRightColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-color"), borderRightColor);
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-style"), borderRightStyle);
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-right-width"), borderRightWidth);
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-spacing"), borderSpacing);
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-style"), borderStyle);
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top"), borderTop);
    }

    @Override
    public void setBorderTopColor(String borderTopColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-color"), borderTopColor);
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-style"), borderTopStyle);
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-top-width"), borderTopWidth);
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("border-width"), borderWidth);
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("bottom"), bottom);
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("caption-side"), captionSide);
    }

    @Override
    public void setClear(String clear) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("clear"), clear);
    }

    @Override
    public void setClip(String clip) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("clip"), clip);
    }

    @Override
    public void setClipBottom(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipBottom"), clip);
    }

    @Override
    public void setClipLeft(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipLeft"), clip);
    }

    @Override
    public void setClipRight(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipRight"), clip);
    }

    @Override
    public void setClipTop(String clip) throws DOMException {
        this.set(PropCMSubProperty.getInstanceOf("clipTop"), clip);
    }

    @Override
    public void setColor(String color) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("color"), color);
    }

    @Override
    public void setContent(String content) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("content"), content);
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("counter-increment"), counterIncrement);
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("counter-reset"), counterReset);
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("float"), cssFloat);
    }

    @Override
    public void setCue(String cue) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue"), cue);
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue-after"), cueAfter);
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cue-before"), cueBefore);
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("cursor"), cursor);
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("direction"), direction);
    }

    @Override
    public void setDisplay(String display) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("display"), display);
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("elevation"), elevation);
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("empty-cells"), emptyCells);
    }

    @Override
    public void setFont(String font) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font"), font);
    }

    @Override
    public void setFontFamily(String fontFamily) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-family"), fontFamily);
    }

    @Override
    public void setFontSize(String fontSize) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-size"), fontSize);
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-size-adjust"), fontSizeAdjust);
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-stretch"), fontStretch);
    }

    @Override
    public void setFontStyle(String fontStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-style"), fontStyle);
    }

    @Override
    public void setFontVariant(String fontVariant) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-variant"), fontVariant);
    }

    @Override
    public void setFontWeight(String fontWeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("font-weight"), fontWeight);
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("height"), height);
    }

    @Override
    public void setLeft(String left) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("left"), left);
    }

    @Override
    public void setLetterSpacing(String letterSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("letter-spacing"), letterSpacing);
    }

    @Override
    public void setLineHeight(String lineHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("line-height"), lineHeight);
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style"), listStyle);
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-image"), listStyleImage);
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-position"), listStylePosition);
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("list-style-type"), listStyleType);
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin"), margin);
    }

    @Override
    public void setMarginBottom(String marginBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-bottom"), marginBottom);
    }

    @Override
    public void setMarginLeft(String marginLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-left"), marginLeft);
    }

    @Override
    public void setMarginRight(String marginRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-right"), marginRight);
    }

    @Override
    public void setMarginTop(String marginTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("margin-top"), marginTop);
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("marker-offset"), markerOffset);
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("marks"), marks);
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("max-height"), maxHeight);
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("max-width"), maxWidth);
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("min-height"), minHeight);
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("min-width"), minWidth);
    }

    @Override
    public void setOrphans(String orphans) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("orphans"), orphans);
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline"), outline);
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-color"), outlineColor);
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-style"), outlineStyle);
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("outline-width"), outlineWidth);
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("overflow"), overflow);
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding"), padding);
    }

    @Override
    public void setPaddingBottom(String paddingBottom) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-bottom"), paddingBottom);
    }

    @Override
    public void setPaddingLeft(String paddingLeft) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-left"), paddingLeft);
    }

    @Override
    public void setPaddingRight(String paddingRight) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-right"), paddingRight);
    }

    @Override
    public void setPaddingTop(String paddingTop) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("padding-top"), paddingTop);
    }

    @Override
    public void setPage(String page) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page"), page);
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-after"), pageBreakAfter);
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-before"), pageBreakBefore);
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("page-break-inside"), pageBreakInside);
    }

    @Override
    public void setPause(String pause) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause"), pause);
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause-after"), pauseAfter);
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pause-before"), pauseBefore);
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pitch"), pitch);
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("pitch-range"), pitchRange);
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("play-during"), playDuring);
    }

    @Override
    public void setPosition(String position) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("position"), position);
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("quotes"), quotes);
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("richness"), richness);
    }

    @Override
    public void setRight(String right) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("right"), right);
    }

    @Override
    public void setSize(String size) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("size"), size);
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak"), speak);
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-header"), speakHeader);
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-numeral"), speakNumeral);
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speak-punctuation"), speakPunctuation);
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("speech-rate"), speechRate);
    }

    @Override
    public void setStress(String stress) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("stress"), stress);
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("table-layout"), tableLayout);
    }

    @Override
    public void setTextAlign(String textAlign) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-align"), textAlign);
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-decoration"), textDecoration);
    }

    @Override
    public void setTextIndent(String textIndent) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-indent"), textIndent);
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-shadow"), textShadow);
    }

    @Override
    public void setTextTransform(String textTransform) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("text-transform"), textTransform);
    }

    @Override
    public void setTop(String top) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("top"), top);
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("unicode-bidi"), unicodeBidi);
    }

    @Override
    public void setVerticalAlign(String verticalAlign) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("vertical-align"), verticalAlign);
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("visibility"), visibility);
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("voice-family"), voiceFamily);
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("volume"), volume);
    }

    @Override
    public void setWhiteSpace(String whiteSpace) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("white-space"), whiteSpace);
    }

    @Override
    public void setWidows(String widows) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("widows"), widows);
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("width"), width);
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("word-spacing"), wordSpacing);
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        this.set(PropCMProperty.getInstanceOf("z-index"), zIndex);
    }
}

