/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class ValidationProblem
extends Status {
    private final Type type;
    private final Object[] params;

    public ValidationProblem(Type type, Object[] params) {
        super(4, "org.eclipse.wst.common.project.facet.core", 0, ValidationProblem.format(type, params), null);
        this.type = type;
        this.params = params;
    }

    public ValidationProblem(Type type) {
        this(type, new Object[0]);
    }

    public ValidationProblem(Type type, Object param) {
        this(type, new Object[]{param});
    }

    public ValidationProblem(Type type, Object param1, Object param2) {
        this(type, new Object[]{param1, param2});
    }

    public ValidationProblem(Type type, Object param1, Object param2, Object param3) {
        this(type, new Object[]{param1, param2, param3});
    }

    public Type getType() {
        return this.type;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValidationProblem)) {
            return false;
        }
        ValidationProblem prob = (ValidationProblem)((Object)obj);
        return this.type.equals(prob.type) && Arrays.equals(this.params, prob.params);
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.params.length) {
            hash ^= this.params[i].hashCode();
            ++i;
        }
        return this.type.hashCode() ^ hash;
    }

    public String toString() {
        return this.getMessage();
    }

    private static String format(Type type, Object[] params) {
        return MessageFormat.format(type.getMessageTemplate(), params);
    }

    private static final class Resources
    extends NLS {
        public static String requires;
        public static String requiresOneOfTwo;
        public static String requiresGroup;
        public static String oneof;
        public static String complex;
        public static String installNotSupported;
        public static String uninstallNotSupported;
        public static String versionChangeNotSupported;
        public static String multipleActionsNotSupported;
        public static String facetAlreadyInstalled;
        public static String cannotUninstall;
        public static String cannotChangeVersion;

        static {
            Resources.initializeMessages((String)ValidationProblem.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    public static final class Type {
        public static final Type REQUIRES = new Type(Resources.requires);
        public static final Type REQUIRES_ONE_OF_TWO = new Type(Resources.requiresOneOfTwo);
        public static final Type REQUIRES_GROUP = new Type(Resources.requiresGroup);
        public static final Type CONFLICTS = new Type(Resources.oneof);
        public static final Type COMPLEX = new Type(Resources.complex);
        public static final Type INSTALL_NOT_SUPPORTED = new Type(Resources.installNotSupported);
        public static final Type UNINSTALL_NOT_SUPPORTED = new Type(Resources.uninstallNotSupported);
        public static final Type VERSION_CHANGE_NOT_SUPPORTED = new Type(Resources.versionChangeNotSupported);
        public static final Type MULTIPLE_ACTIONS_NOT_SUPPORTED = new Type(Resources.multipleActionsNotSupported);
        public static final Type FACET_ALREADY_INSTALLED = new Type(Resources.facetAlreadyInstalled);
        public static final Type CANNOT_UNINSTALL = new Type(Resources.cannotUninstall);
        public static final Type CANNOT_CHANGE_VERSION = new Type(Resources.cannotChangeVersion);
        public final String msg;

        private Type(String msg) {
            this.msg = msg;
        }

        private String getMessageTemplate() {
            return this.msg;
        }
    }
}

