/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.cdt.make.ui.TargetSourceContainer;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class AddTargetAction
extends SelectionListenerAction {
    private final Shell shell;

    public AddTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("AddTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("AddTargetAction.tooltip"));
        this.setDisabledImageDescriptor(MakeUIImages.getImageDescriptor("icons/dtool16/target_add.gif"));
        this.setImageDescriptor(MakeUIImages.getImageDescriptor("icons/etool16/target_add.gif"));
        this.setEnabled(false);
    }

    public void run() {
        Object selection = this.getSelectedElement();
        try {
            if (selection instanceof IMakeTarget) {
                IMakeTarget makeTarget = (IMakeTarget)selection;
                MakeTargetDndUtil.copyOneTarget(makeTarget, makeTarget.getContainer(), 1, this.shell, false);
            } else {
                IContainer container = null;
                if (selection instanceof TargetSourceContainer) {
                    container = ((TargetSourceContainer)selection).getContainer();
                } else if (selection instanceof IContainer) {
                    container = (IContainer)selection;
                }
                if (container != null) {
                    MakeTargetDialog dialog = new MakeTargetDialog(this.shell, container);
                    dialog.open();
                }
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("AddTargetAction.exception.title"), MakeUIPlugin.getResourceString("AddTargetAction.exception.message"), e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.getSelectedElement() != null;
    }

    private Object getSelectedElement() {
        Object element;
        if (this.getStructuredSelection().size() == 1 && ((element = this.getStructuredSelection().getFirstElement()) instanceof IContainer || element instanceof TargetSourceContainer || element instanceof IMakeTarget)) {
            return element;
        }
        return null;
    }
}

