/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageScanner;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class DelegatingUsageCollector
implements IUsageCollector {
    protected List<IUsageScanner> scanners = new ArrayList<IUsageScanner>();
    private List<IUsageCollector> delegates = new ArrayList<IUsageCollector>();
    private String reportTitle = "";

    public void addScanner(IUsageScanner aScanner) {
        this.scanners.add(aScanner);
    }

    public List<IUsageCollector> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<IUsageCollector> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        for (IUsageCollector collector : this.delegates) {
            collector.consumeEvent(event, userId);
        }
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> combinedReports = new ArrayList<String>();
        for (IUsageCollector collector : this.delegates) {
            combinedReports.add("<h3>" + collector.getReportTitle() + "</h3>");
            combinedReports.addAll(collector.getReport());
        }
        return combinedReports;
    }

    @Override
    public void exportAsCSVFile(String directory) {
    }

    @Override
    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> combinedReports = new ArrayList<String>();
        for (IUsageCollector collector : this.delegates) {
            combinedReports.add(collector.getReportTitle());
            combinedReports.addAll(collector.getPlainTextReport());
        }
        return combinedReports;
    }
}

