/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.actions.FindAction;
import org.eclipse.dltk.ui.actions.FindReferencesAction;
import org.eclipse.dltk.ui.actions.FindReferencesInHierarchyAction;
import org.eclipse.dltk.ui.actions.FindReferencesInProjectAction;
import org.eclipse.dltk.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_references;
    private IWorkbenchSite fSite;
    private AbstractDecoratedTextEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReferencesAction fFindReferencesAction;
    private FindReferencesInProjectAction fFindReferencesInProjectAction;
    private FindReferencesInHierarchyAction fFindReferencesInHierarchyAction;
    private FindReferencesInWorkingSetAction fFindReferencesInWorkingSetAction;
    private final IDLTKLanguageToolkit toolkit;
    private ISelectionProvider fSelectionProvider;

    public ReferencesSearchGroup(IWorkbenchSite site, IDLTKLanguageToolkit tk) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.toolkit = tk;
        this.fFindReferencesAction = new FindReferencesAction(this.toolkit, site);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.workspace");
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.toolkit, site);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.project");
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(this.toolkit, site);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.hierarchy");
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.toolkit, site);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.working.set");
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        assert (this.fSelectionProvider != null);
        this.registerActions();
    }

    public ReferencesSearchGroup(ScriptEditor editor, IDLTKLanguageToolkit tk) {
        this((AbstractDecoratedTextEditor)editor, tk);
    }

    public ReferencesSearchGroup(AbstractDecoratedTextEditor editor, IDLTKLanguageToolkit tk) {
        Assert.isNotNull((Object)editor);
        this.toolkit = tk;
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReferencesAction = new FindReferencesAction(this.toolkit, editor);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.workspace");
        this.fEditor.setAction("SearchReferencesInWorkspace", (IAction)this.fFindReferencesAction);
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.toolkit, this.fEditor);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.project");
        this.fEditor.setAction("SearchReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(this.toolkit, this.fEditor);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.hierarchy");
        this.fEditor.setAction("SearchReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.toolkit, this.fEditor);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.references.in.working.set");
        this.fEditor.setAction("SearchReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    protected String getName() {
        return MENU_TEXT;
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReferencesInWorkingSetAction(this.toolkit, this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReferencesInWorkingSetAction(this.toolkit, this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(this.getName(), "group.search");
        this.addAction((IAction)this.fFindReferencesAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReferencesInProjectAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReferencesInHierarchyAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindReferencesInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        this.unregisterActions();
        this.fSelectionProvider = null;
        this.fFindReferencesAction = null;
        this.fFindReferencesInProjectAction = null;
        this.fFindReferencesInHierarchyAction = null;
        this.fFindReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.ReferencesInWorkspace", (IAction)this.fFindReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.ReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.ReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.ReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void registerActions() {
        if (this.fEditor != null) {
            return;
        }
        ISelection selection = this.fSelectionProvider.getSelection();
        this.registerAction(this.fFindReferencesAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindReferencesInProjectAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindReferencesInHierarchyAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindReferencesInWorkingSetAction, this.fSelectionProvider, selection);
    }

    private void unregisterActions() {
        if (this.fEditor != null) {
            return;
        }
        this.disposeAction(this.fFindReferencesAction, this.fSelectionProvider);
        this.disposeAction(this.fFindReferencesInProjectAction, this.fSelectionProvider);
        this.disposeAction(this.fFindReferencesInHierarchyAction, this.fSelectionProvider);
        this.disposeAction(this.fFindReferencesInWorkingSetAction, this.fSelectionProvider);
    }

    public void setSpecialSelectionProvider(ISelectionProvider provider) {
        assert (this.fEditor != null || provider != null);
        this.unregisterActions();
        this.fSelectionProvider = provider;
        this.registerActions();
        this.fFindReferencesAction.setSpecialSelectionProvider(provider);
        this.fFindReferencesInProjectAction.setSpecialSelectionProvider(provider);
        this.fFindReferencesInHierarchyAction.setSpecialSelectionProvider(provider);
        this.fFindReferencesInWorkingSetAction.setSpecialSelectionProvider(provider);
    }
}

