/*******************************************************************************
 * Copyright (c) 2000, 2026 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.util.Set;

import org.eclipse.core.runtime.Assert;



class Properties extends java.util.Properties {

	private static final long serialVersionUID= 1L;

	private Set<Object> fDuplicateKeys;

	public Properties() {
	}

	public Properties(Set<Object> duplicateKeys) {
		super();
		Assert.isNotNull(duplicateKeys);
		fDuplicateKeys= duplicateKeys;
	}

	public Properties (Properties properties, Set<Object> duplicateKeys) {
		super(properties);
		Assert.isNotNull(duplicateKeys);
		fDuplicateKeys= duplicateKeys;
	}
	@Override
	public synchronized Object put(Object arg0, Object arg1) {
		if (arg0 != null && containsKey(arg0))
			fDuplicateKeys.add(arg0);
		return super.put(arg0, arg1);
	}
}
