/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexV1;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.SilentFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPackIndexLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MultiPackIndexLoader.class);

    public static MultiPackIndex open(File midxFile) throws FileNotFoundException, MultiPackIndexFormatException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(midxFile);){
            return MultiPackIndexLoader.read(fd);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static MultiPackIndex read(InputStream fd) throws MultiPackIndexFormatException, IOException {
        byte[] hdr = new byte[12];
        IO.readFully(fd, hdr, 0, hdr.length);
        int magic = NB.decodeInt32(hdr, 0);
        if (magic != 1296647256) {
            throw new MultiPackIndexFormatException(JGitText.get().notAMIDX);
        }
        byte v = hdr[4];
        if (v != 1) {
            throw new MultiPackIndexFormatException(MessageFormat.format(JGitText.get().unsupportedMIDXVersion, v));
        }
        byte commitIdVersion = hdr[5];
        if (commitIdVersion != 1) {
            throw new MultiPackIndexFormatException(JGitText.get().incorrectOBJECT_ID_LENGTH);
        }
        int chunkCount = hdr[6];
        int packCount = NB.decodeInt32(hdr, 8);
        byte[] lookupBuffer = new byte[12 * (chunkCount + 1)];
        IO.readFully(fd, lookupBuffer, 0, lookupBuffer.length);
        ArrayList<ChunkSegment> chunks = new ArrayList<ChunkSegment>(chunkCount + 1);
        int i = 0;
        while (i <= chunkCount) {
            int id = NB.decodeInt32(lookupBuffer, i * 12);
            long offset = NB.decodeInt64(lookupBuffer, i * 12 + 4);
            chunks.add(new ChunkSegment(id, offset));
            ++i;
        }
        MultiPackIndexBuilder builder = MultiPackIndexBuilder.builder();
        builder.setPackCount(packCount);
        int i2 = 0;
        while (i2 < chunkCount) {
            long chunkOffset = ((ChunkSegment)chunks.get((int)i2)).offset;
            int chunkId = ((ChunkSegment)chunks.get((int)i2)).id;
            long len = ((ChunkSegment)chunks.get((int)(i2 + 1))).offset - chunkOffset;
            if (len > 0x7FFFFFF7L) {
                throw new MultiPackIndexFormatException(JGitText.get().multiPackIndexFileIsTooLargeForJgit);
            }
            byte[] buffer = new byte[(int)len];
            IO.readFully(fd, buffer, 0, buffer.length);
            switch (chunkId) {
                case 1330201670: {
                    builder.addOidFanout(buffer);
                    break;
                }
                case 1330201676: {
                    builder.addOidLookUp(buffer);
                    break;
                }
                case 1347305805: {
                    builder.addPackNames(buffer);
                    break;
                }
                case 1112821072: {
                    builder.addBitmappedPacks(buffer);
                    break;
                }
                case 0x4F4F4646: {
                    builder.addObjectOffsets(buffer);
                    break;
                }
                case 1280263750: {
                    builder.addObjectLargeOffsets(buffer);
                    break;
                }
                case 1380533336: {
                    builder.addReverseIndex(buffer);
                    break;
                }
                default: {
                    LOG.warn(MessageFormat.format(JGitText.get().midxChunkUnknown, Integer.toHexString(chunkId)));
                }
            }
            ++i2;
        }
        byte[] checksum = new byte[20];
        IO.readFully(fd, checksum, 0, 20);
        builder.addChecksum(checksum);
        return builder.build();
    }

    private record ChunkSegment(int id, long offset) {
    }

    static class MultiPackIndexBuilder {
        private final int hashLength;
        private int packCount;
        private byte[] oidFanout;
        private byte[] oidLookup;
        private String[] packNames;
        private byte[] bitmappedPackfiles;
        private byte[] objectOffsets;
        private byte[] largeObjectOffsets;
        private byte[] bitmapPackOrder;
        private byte[] checksum;

        private MultiPackIndexBuilder(int hashLength) {
            this.hashLength = hashLength;
        }

        static MultiPackIndexBuilder builder() {
            return new MultiPackIndexBuilder(20);
        }

        MultiPackIndexBuilder setPackCount(int packCount) {
            this.packCount = packCount;
            return this;
        }

        MultiPackIndexBuilder addOidFanout(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.oidFanout, 1330201670);
            this.oidFanout = buffer;
            return this;
        }

        MultiPackIndexBuilder addOidLookUp(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.oidLookup, 1330201676);
            this.oidLookup = buffer;
            return this;
        }

        MultiPackIndexBuilder addPackNames(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.packNames, 1347305805);
            this.packNames = new String(buffer, StandardCharsets.UTF_8).split("\u0000");
            return this;
        }

        MultiPackIndexBuilder addBitmappedPacks(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.bitmappedPackfiles, 1112821072);
            this.bitmappedPackfiles = buffer;
            return this;
        }

        MultiPackIndexBuilder addObjectOffsets(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.objectOffsets, 0x4F4F4646);
            this.objectOffsets = buffer;
            return this;
        }

        MultiPackIndexBuilder addObjectLargeOffsets(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.largeObjectOffsets, 1280263750);
            this.largeObjectOffsets = buffer;
            return this;
        }

        MultiPackIndexBuilder addReverseIndex(byte[] buffer) throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotSeenYet(this.bitmapPackOrder, 1380533336);
            this.bitmapPackOrder = buffer;
            return this;
        }

        MultiPackIndex build() throws MultiPackIndexFormatException {
            MultiPackIndexBuilder.assertChunkNotNull(this.oidFanout, 1330201670);
            MultiPackIndexBuilder.assertChunkNotNull(this.oidLookup, 1330201676);
            MultiPackIndexBuilder.assertChunkNotNull(this.packNames, 1347305805);
            MultiPackIndexBuilder.assertChunkNotNull(this.objectOffsets, 0x4F4F4646);
            MultiPackIndexBuilder.assertPackCounts(this.packCount, this.packNames.length);
            return new MultiPackIndexV1(this.hashLength, this.oidFanout, this.oidLookup, this.packNames, this.bitmappedPackfiles, this.objectOffsets, this.largeObjectOffsets, this.bitmapPackOrder, this.checksum);
        }

        private static void assertChunkNotNull(Object object, int chunkId) throws MultiPackIndexFormatException {
            if (object == null) {
                throw new MultiPackIndexFormatException(MessageFormat.format(JGitText.get().midxChunkNeeded, Integer.toHexString(chunkId)));
            }
        }

        private static void assertChunkNotSeenYet(Object object, int chunkId) throws MultiPackIndexFormatException {
            if (object != null) {
                throw new MultiPackIndexFormatException(MessageFormat.format(JGitText.get().midxChunkRepeated, Integer.toHexString(chunkId)));
            }
        }

        private static void assertPackCounts(int headerCount, int packfileNamesCount) throws MultiPackIndexFormatException {
            if (headerCount != packfileNamesCount) {
                throw new MultiPackIndexFormatException(MessageFormat.format(JGitText.get().multiPackIndexPackCountMismatch, headerCount, packfileNamesCount));
            }
        }

        public void addChecksum(byte[] checksum) {
            this.checksum = checksum;
        }
    }

    public static class MultiPackIndexFormatException
    extends IOException {
        private static final long serialVersionUID = 1L;

        MultiPackIndexFormatException(String why) {
            super(why);
        }
    }
}

