/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;

public class HyperlinkDetectorDelegate
implements IHyperlinkDetector,
IHyperlinkDetectorExtension,
IHyperlinkDetectorExtension2 {
    private HyperlinkDetectorDescriptor descriptor;
    private IHyperlinkDetector delegate;
    private boolean createFailed;
    private IAdaptable context;
    private int stateMask;
    private boolean enabled;

    public HyperlinkDetectorDelegate(HyperlinkDetectorDescriptor descriptor, IPreferenceStore preferenceStore) {
        this.descriptor = descriptor;
        if (preferenceStore != null) {
            this.stateMask = preferenceStore.getInt(descriptor.getId() + "_stateMask");
            this.enabled = !preferenceStore.getBoolean(descriptor.getId());
        }
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!this.createFailed && this.delegate == null) {
            IHyperlinkDetector iHyperlinkDetector;
            try {
                this.delegate = this.descriptor.createHyperlinkDetectorImplementation();
            }
            catch (CoreException ex) {
                this.createFailed = true;
            }
            if (this.context != null && (iHyperlinkDetector = this.delegate) instanceof AbstractHyperlinkDetector) {
                AbstractHyperlinkDetector ahd = (AbstractHyperlinkDetector)iHyperlinkDetector;
                ahd.setContext(this.context);
            }
        }
        if (this.delegate != null) {
            return this.delegate.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setContext(IAdaptable context) {
        this.context = context;
    }

    public void dispose() {
        if (this.delegate != null) {
            IHyperlinkDetector iHyperlinkDetector = this.delegate;
            if (iHyperlinkDetector instanceof IHyperlinkDetectorExtension) {
                IHyperlinkDetectorExtension hde = (IHyperlinkDetectorExtension)iHyperlinkDetector;
                hde.dispose();
            }
            this.delegate = null;
        }
        this.descriptor = null;
        this.context = null;
    }

    public int getStateMask() {
        return this.stateMask;
    }
}

