/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LabelLocator;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceMessageEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.tools.SequenceMessageSelectConnectionEditPartTracker;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.SequenceMessageLabelLocator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceMessagesRouter;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.swt.graphics.Cursor;

public class SequenceMessageEditPart
extends DEdgeEditPart
implements ISequenceEventEditPart {
    public static final String MSG_TO_SELF_TOP_MOVE = "messageToSelfTopMove";
    public static final String MSG_OBLIQUE_CBR_INITAL_CLICK = "messageObliqueChangeBoundsRequestInitialClick";
    private static final ConnectionRouter ROUTER = new SequenceMessagesRouter();

    public SequenceMessageEditPart(View view) {
        super(view);
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, (EObject)this.resolveDiagramElement());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, this.resolveSemanticElement());
    }

    protected void installRouter() {
        this.getPrimaryShape().setConnectionRouter(ROUTER);
        this.setCursor(Cursors.CURSOR_SEG_MOVE);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if ("Connection Bendpoint Policy".equals(key)) {
            super.installEditPolicy(key, (EditPolicy)new SequenceMessageEditPolicy());
            this.setCursor(Cursors.CURSOR_SEG_MOVE);
        } else {
            super.installEditPolicy(key, editPolicy);
        }
    }

    public void showSourceFeedback(Request request) {
        if (!(request instanceof ReconnectRequest)) {
            super.showSourceFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        if (!(request instanceof ReconnectRequest)) {
            super.showTargetFeedback(request);
        }
    }

    public void setCursor(final Cursor cursor) {
        EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                Connection connectionFigure = SequenceMessageEditPart.this.getConnectionFigure();
                connectionFigure.setCursor(cursor);
            }
        });
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof SelectionRequest) {
            this.setCursor(Cursors.CURSOR_SEG_MOVE);
        }
        return super.getTargetEditPart(request);
    }

    public void refreshBendpoints() {
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.getEdge().getBendpoints();
        List modelConstraint = bendpoints.getPoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint wbp = (org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(new Dimension(wbp.getSourceX(), wbp.getSourceY()), new Dimension(wbp.getTargetX(), wbp.getTargetY()));
            rbp.setWeight(0.0f);
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        if (constraint instanceof LabelLocator) {
            SequenceMessageLabelLocator smll = new SequenceMessageLabelLocator(childFigure.getParent(), (LabelLocator)constraint);
            super.setLayoutConstraint(child, childFigure, (Object)smll);
        } else {
            super.setLayoutConstraint(child, childFigure, constraint);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return new SequenceMessageSelectConnectionEditPartTracker((ConnectionEditPart)this);
    }

    @Override
    public ISequenceEvent getISequenceEvent() {
        return (ISequenceEvent)ISequenceElementAccessor.getMessage((View)this.getNotationView()).get();
    }
}

