/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.preference;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.internal.preferences.PreferenceHelper;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.business.internal.preference.SessionPreferenceComponent;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SiriusPreferencesPropertyPage
extends PropertyPage {
    private ProjectScope projectScope;
    private String siriusUiQualifier;
    private String siriusQualifier;
    private SessionPreferenceComponent component;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IResource resourceAird = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        IProject project = resourceAird.getProject();
        this.projectScope = new ProjectScope(project);
        String sessionId = this.getSessionId(resourceAird);
        this.siriusQualifier = "org.eclipse.sirius" + sessionId;
        this.siriusUiQualifier = "org.eclipse.sirius.ui" + sessionId;
        this.component = new SessionPreferenceComponent();
        Composite composite = this.component.createComposite(parent);
        this.initialize(sessionId);
        return composite;
    }

    private String getSessionId(IResource resourceAird) {
        SearchDAnalysisUidHandler testHandler;
        String dAnalysisUid;
        block15: {
            dAnalysisUid = "";
            InputStream inputStream = null;
            testHandler = new SearchDAnalysisUidHandler();
            try {
                inputStream = new FileInputStream(new File(resourceAird.getRawLocation().toOSString()));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(inputStream, (DefaultHandler)testHandler);
            }
            catch (SAXException sAXException) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
                }
                break block15;
            }
            catch (IOException | ParserConfigurationException e) {
                try {
                    SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        SiriusPlugin.getDefault().error(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().error(e.getMessage(), (Throwable)e);
            }
        }
        dAnalysisUid = testHandler.getSessionId();
        return dAnalysisUid;
    }

    private void initialize(String sessionId) {
        boolean isProjectSpecificSettings = this.isProjectSpecificSettings();
        this.component.setProjectSpecificSettings(isProjectSpecificSettings);
        this.component.setRefreshAtOpening((Boolean)PreferenceHelper.getPreference((IScopeContext)this.projectScope, (String)"org.eclipse.sirius.ui", (String)sessionId, (String)SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), Boolean.class));
        this.component.setAutoRefresh((Boolean)PreferenceHelper.getPreference((IScopeContext)this.projectScope, (String)"org.eclipse.sirius", (String)sessionId, (String)SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), Boolean.class));
    }

    private boolean isProjectSpecificSettings() {
        try {
            return this.projectScope.getNode(this.siriusQualifier).keys().length > 0;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean performOk() {
        try {
            if (this.component.isProjectSpecificSettings()) {
                this.projectScope.getNode(this.siriusUiQualifier).putBoolean(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), this.component.isRefreshAtOpening());
                this.projectScope.getNode(this.siriusQualifier).putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), this.component.isAutoRefresh());
            } else {
                this.projectScope.getNode(this.siriusUiQualifier).clear();
                this.projectScope.getNode(this.siriusQualifier).clear();
            }
            this.projectScope.getNode(this.siriusQualifier).flush();
            this.projectScope.getNode(this.siriusUiQualifier).flush();
        }
        catch (BackingStoreException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", e.getMessage(), (Throwable)e));
        }
        return true;
    }

    private final class SearchDAnalysisUidHandler
    extends DefaultHandler {
        private final String dAnalysisTag = "viewpoint:" + ViewpointPackage.eINSTANCE.getDAnalysis().getName();
        private String dAnalysisUid;

        private SearchDAnalysisUidHandler() {
        }

        public String getSessionId() {
            return this.dAnalysisUid;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(this.dAnalysisTag)) {
                this.dAnalysisUid = attributes.getValue(ViewpointPackage.eINSTANCE.getIdentifiedElement_Uid().getName());
                throw new SAXException();
            }
        }
    }
}

