/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class JSONTypingPreferencePage
extends AbstractPreferencePage {
    private Button fCloseBraces;
    private Button fCloseBrackets;
    private Button fCloseStrings;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createAutoComplete(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createAutoComplete(Composite parent) {
        Group group = this.createGroup(parent, 1);
        group.setText(JSONUIMessages.Automatically_close);
        this.fCloseBraces = this.createCheckBox((Composite)group, JSONUIMessages.Close_braces);
        this.fCloseBrackets = this.createCheckBox((Composite)group, JSONUIMessages.Close_brackets);
        this.fCloseStrings = this.createCheckBox((Composite)group, JSONUIMessages.Close_strings);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        JSONUIPlugin.getDefault().savePluginPreferences();
        return result;
    }

    protected void initializeValues() {
        this.initCheckbox(this.fCloseBraces, "closeBraces");
        this.initCheckbox(this.fCloseBrackets, "closeBrackets");
        this.initCheckbox(this.fCloseStrings, "closeStrings");
    }

    protected void performDefaults() {
        this.defaultCheckbox(this.fCloseBraces, "closeBraces");
        this.defaultCheckbox(this.fCloseBrackets, "closeBrackets");
        this.defaultCheckbox(this.fCloseStrings, "closeStrings");
    }

    protected void storeValues() {
        this.getPreferenceStore().setValue("closeBraces", this.fCloseBraces != null ? this.fCloseBraces.getSelection() : false);
        this.getPreferenceStore().setValue("closeBrackets", this.fCloseBrackets != null ? this.fCloseBrackets.getSelection() : false);
        this.getPreferenceStore().setValue("closeStrings", this.fCloseStrings != null ? this.fCloseStrings.getSelection() : false);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSONUIPlugin.getDefault().getPreferenceStore();
    }
}

