/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.pde.bnd.ui.HierarchicalLabel;

public class HierarchicalMenu {
    private final List<HierarchicalLabel<Action>> labels = new ArrayList<HierarchicalLabel<Action>>();

    public HierarchicalMenu add(HierarchicalLabel<Action> label) {
        this.labels.add(label);
        return this;
    }

    public void build(IMenuManager root) {
        HierarchicalMenu.createMenu(this.labels, root);
    }

    public static void createMenu(List<HierarchicalLabel<Action>> labels, IMenuManager rootMenu) {
        LinkedHashMap<String, IMenuManager> menus = new LinkedHashMap<String, IMenuManager>();
        for (HierarchicalLabel<Action> hl : labels) {
            IMenuManager current = rootMenu;
            List<String> hlLabels = hl.getLabels();
            int i = 0;
            while (i < hlLabels.size()) {
                String currentLabel = hlLabels.get(i);
                if (i == hlLabels.size() - 1) {
                    current.add((IAction)hl.getLeafAction());
                } else {
                    current = HierarchicalMenu.getOrCreateSubMenu(menus, current, currentLabel);
                }
                ++i;
            }
        }
    }

    private static IMenuManager getOrCreateSubMenu(Map<String, IMenuManager> menus, IMenuManager parent, String label) {
        String key = parent.toString() + " -> " + label;
        if (!menus.containsKey(key)) {
            MenuManager newMenu = new MenuManager(label, null);
            parent.add((IContributionItem)newMenu);
            menus.put(key, (IMenuManager)newMenu);
        }
        return menus.get(key);
    }
}

