/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missinggrammar;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missinggrammar.GenerateDTDCodeActionResolver;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missinggrammar.GenerateXSDCodeActionResolver;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorManager;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public abstract class AbstractFixMissingGrammarCodeAction
implements ICodeActionParticipant {
    private static final String FILE_SCHEME = "'file:///";
    private final Map<String, ICodeActionResolvesParticipant> resolveCodeActionParticipants = new HashMap<String, ICodeActionResolvesParticipant>();

    public AbstractFixMissingGrammarCodeAction() {
        this.resolveCodeActionParticipants.put(GenerateDTDCodeActionResolver.PARTICIPANT_ID, new GenerateDTDCodeActionResolver());
        this.resolveCodeActionParticipants.put(GenerateXSDCodeActionResolver.PARTICIPANT_ID, new GenerateXSDCodeActionResolver());
    }

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Diagnostic diagnostic = request.getDiagnostic();
        String missingFilePath = this.getPathFromDiagnostic(diagnostic);
        if (StringUtils.isEmpty(missingFilePath)) {
            return;
        }
        Path p = Paths.get(missingFilePath, new String[0]);
        if (p.toFile().exists()) {
            return;
        }
        CodeAction makeSchemaFile = this.createGenerateFileCodeAction(request, diagnostic, missingFilePath, p, cancelChecker);
        codeActions.add(makeSchemaFile);
    }

    @Override
    public ICodeActionResolvesParticipant getResolveCodeActionParticipant(String participantId) {
        return this.resolveCodeActionParticipants.get(participantId);
    }

    private CodeAction createGenerateFileCodeAction(ICodeActionRequest request, Diagnostic diagnostic, String missingFilePath, Path p, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        String title = "Generate missing file '" + p.toFile().getName() + "'";
        if (request.canSupportResolve()) {
            CodeAction makeSchemaFile = new CodeAction(title);
            makeSchemaFile.setDiagnostics(Collections.singletonList(diagnostic));
            makeSchemaFile.setKind("quickfix");
            JsonObject data = DataEntryField.createData(document.getDocumentURI(), this.getParticipantId());
            data.addProperty("file", missingFilePath);
            makeSchemaFile.setData(data);
            return makeSchemaFile;
        }
        SharedSettings sharedSettings = request.getSharedSettings();
        FileContentGeneratorManager generator = (FileContentGeneratorManager)request.getComponent(FileContentGeneratorManager.class);
        String schemaTemplate = generator.generate(document, sharedSettings, this.getFileContentGeneratorSettings(), cancelChecker);
        CodeAction makeSchemaFile = CodeActionFactory.createFile(title, "file:///" + missingFilePath, schemaTemplate, diagnostic);
        return makeSchemaFile;
    }

    protected abstract String getParticipantId();

    private String getPathFromDiagnostic(Diagnostic diagnostic) {
        String message = diagnostic.getMessage();
        int startIndex = message.indexOf(FILE_SCHEME);
        if (startIndex != -1) {
            int endIndex = message.lastIndexOf("'");
            return message.substring(startIndex + FILE_SCHEME.length(), endIndex);
        }
        return null;
    }

    protected abstract FileContentGeneratorSettings getFileContentGeneratorSettings();
}

