/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class EnvironmentReader {
    private static Properties envVars;
    private static List<String> toUppercaseEnvironmentVars;

    static {
        toUppercaseEnvironmentVars = Arrays.asList("PATH", "CYGWIN_HOME", "LANG");
        boolean isWindows = "win32".equals(Platform.getOS());
        envVars = new Properties();
        Map<String, String> envMap = System.getenv();
        for (Map.Entry<String, String> curEnvVar : envMap.entrySet()) {
            String key = curEnvVar.getKey();
            String value = curEnvVar.getValue();
            if (isWindows && toUppercaseEnvironmentVars.contains(key.toUpperCase())) {
                key = key.toUpperCase();
            }
            envVars.setProperty(key, value);
        }
    }

    public static Properties getEnvVars() {
        return (Properties)envVars.clone();
    }

    public static String getEnvVar(String key) {
        return envVars.getProperty(key);
    }
}

