/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceGroup;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.jgit.lib.Repository;

public class DecoratableResourceMapping
extends DecoratableResourceGroup {
    private static final String MULTIPLE = "*";
    public static final int RESOURCE_MAPPING = 16;

    public DecoratableResourceMapping(ResourceMapping mapping) throws IOException {
        super(mapping);
        HashSet<Repository> repositories = new HashSet<Repository>();
        HashSet<GitItemState.StagingState> stagingStates = new HashSet<GitItemState.StagingState>();
        List extractResourcesFromMapping = ResourceUtil.extractResourcesFromMapping((ResourceMapping)mapping);
        boolean anyIsTracked = false;
        boolean anyIsConflict = false;
        boolean anyIsDirty = false;
        for (IResource mappingResource : extractResourcesFromMapping) {
            IndexDiffData indexDiffData;
            if (mappingResource == null || (indexDiffData = GitItemStateFactory.getInstance().getIndexDiffDataOrNull(mappingResource)) == null) continue;
            Repository repository = ResourceUtil.getRepository((IResource)mappingResource);
            repositories.add(repository);
            DecoratableResourceAdapter adapter = new DecoratableResourceAdapter(indexDiffData, mappingResource);
            if (adapter.isTracked()) {
                anyIsTracked = true;
            }
            if (adapter.hasConflicts()) {
                anyIsConflict = true;
            }
            if (adapter.isDirty()) {
                anyIsDirty = true;
            }
            stagingStates.add(adapter.getStagingState());
        }
        if (anyIsTracked) {
            this.setTracked(true);
        }
        if (anyIsConflict) {
            this.setConflicts(true);
        }
        if (anyIsDirty) {
            this.setDirty(true);
        }
        if (stagingStates.isEmpty()) {
            this.setStagingState(GitItemState.StagingState.NOT_STAGED);
        } else if (stagingStates.size() == 1) {
            GitItemState.StagingState state = (GitItemState.StagingState)stagingStates.iterator().next();
            if (state != null) {
                this.setStagingState(state);
            }
        } else {
            this.setStagingState(GitItemState.StagingState.MODIFIED);
        }
        if (repositories.isEmpty()) {
            return;
        }
        this.someShared = true;
        DecoratableResourceMapping.decorateRepositoryInformation(this, repositories);
    }

    protected static void decorateRepositoryInformation(DecoratableResource resource, Collection<Repository> repositories) throws IOException {
        if (repositories.size() == 1) {
            Repository repository = repositories.iterator().next();
            resource.repositoryName = DecoratorRepositoryStateCache.INSTANCE.getRepositoryNameAndState(repository);
            resource.branch = DecoratorRepositoryStateCache.INSTANCE.getCurrentBranchLabel(repository);
            resource.branchStatus = DecoratorRepositoryStateCache.INSTANCE.getBranchStatus(repository);
        } else if (repositories.size() > 1) {
            HashSet<String> branches = new HashSet<String>(2);
            for (Repository repository : repositories) {
                branches.add(DecoratorRepositoryStateCache.INSTANCE.getCurrentBranchLabel(repository));
                if (branches.size() > 1) break;
            }
            if (branches.size() == 1) {
                resource.repositoryName = MULTIPLE;
                resource.branch = (String)branches.iterator().next();
            }
        }
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public String getName() {
        return "<unknown>";
    }
}

