/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import org.eclipse.ant.internal.launching.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class AntConsoleColorProvider
extends ConsoleColorProvider
implements IPropertyChangeListener {
    public Color getColor(String streamIdentifer) {
        if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.informationColor");
        }
        if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.errorColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.launching.ANT_DEBUG_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.debugColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.launching.ANT_VERBOSE_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.verboseColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.launching.ANT_WARNING_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.warningColor");
        }
        return super.getColor(streamIdentifer);
    }

    public void connect(IProcess process, IConsole console) {
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (proxy != null) {
            console.connect(proxy.getDebugStreamMonitor(), "org.eclipse.ant.launching.ANT_DEBUG_STREAM");
            console.connect(proxy.getWarningStreamMonitor(), "org.eclipse.ant.launching.ANT_WARNING_STREAM");
            console.connect(proxy.getVerboseStreamMonitor(), "org.eclipse.ant.launching.ANT_VERBOSE_STREAM");
        }
        AntUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        super.connect(process, console);
    }

    public boolean isReadOnly() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String streamId = this.getStreamId(event.getProperty());
        if (streamId != null) {
            AntUIPlugin.getStandardDisplay().asyncExec(() -> {
                IOConsoleOutputStream stream = this.getConsole().getStream(streamId);
                if (stream != null) {
                    stream.setColor(this.getColor(streamId));
                }
            });
        }
    }

    private String getStreamId(String colorId) {
        if ("org.eclipse.ant.ui.debugColor".equals(colorId)) {
            return "org.eclipse.ant.launching.ANT_DEBUG_STREAM";
        }
        if ("org.eclipse.ant.ui.errorColor".equals(colorId)) {
            return "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM";
        }
        if ("org.eclipse.ant.ui.informationColor".equals(colorId)) {
            return "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM";
        }
        if ("org.eclipse.ant.ui.verboseColor".equals(colorId)) {
            return "org.eclipse.ant.launching.ANT_VERBOSE_STREAM";
        }
        if ("org.eclipse.ant.ui.warningColor".equals(colorId)) {
            return "org.eclipse.ant.launching.ANT_WARNING_STREAM";
        }
        return null;
    }

    public void disconnect() {
        AntUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.disconnect();
    }
}

