/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.WSDLException;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.UDDIReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.profile.ProfileArtifact;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.UDDIValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class UDDIValidatorImpl
extends BaseValidatorImpl
implements UDDIValidator {
    protected UDDIReference uddiReference;
    protected UDDIProxy uddiProxy;
    private boolean testable;

    @Override
    public String getArtifactType() {
        return "discovery";
    }

    @Override
    public String[] getEntryTypes() {
        return new String[]{"bindingTemplate", "tModel"};
    }

    @Override
    public void init(AnalyzerContext analyzerContext, ProfileAssertions assertions, ReportArtifact reportArtifact, AnalyzerConfig analyzerConfig, Reporter reporter) throws WSIException {
        super.init(analyzerContext, assertions.getArtifact("discovery"), reportArtifact, reporter);
        this.uddiReference = analyzerConfig.getUDDIReference();
        this.testable = analyzerConfig.isUDDIReferenceSet();
    }

    @Override
    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, UDDIReference uddiReference, Reporter reporter) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        AnalyzerConfig analyzerConfig = Utils.getAnalyzerConfig(reporter);
        this.testable = analyzerConfig != null && analyzerConfig.isUDDIReferenceSet();
        this.uddiReference = uddiReference;
    }

    @Override
    public void validateArtifact() throws WSIException {
        Entry entry = null;
        BindingTemplate bindingTemplate = null;
        TModel tModel = null;
        String classPrefix = String.valueOf(this.getClass().getPackage().getName()) + ".";
        try {
            this.uddiProxy = new UDDIProxy();
            this.uddiProxy.setInquiryURL(this.uddiReference.getInquiryURL());
            boolean wasEx = false;
            try {
                URL url = StringUtils.getURL(null, (String)this.uddiReference.getInquiryURL());
                InputStream stream = url.openStream();
                stream.close();
            }
            catch (UnknownHostException unknownHostException) {
                wasEx = true;
            }
            catch (IOException iOException) {}
            if (!wasEx) {
                if (this.uddiReference.getKeyType().equals("bindingKey")) {
                    BindingDetail bindingDetail = this.uddiProxy.get_bindingDetail(this.uddiReference.getKey());
                    bindingTemplate = (BindingTemplate)bindingDetail.getBindingTemplateVector().elementAt(0);
                    if (this.verboseOption) {
                        System.err.println("    BindingTemplate - " + UDDIUtils.bindingTemplateToString(bindingTemplate));
                    }
                    tModel = UDDIUtils.findTModel(this.uddiProxy, bindingTemplate, this.verboseOption);
                } else {
                    TModelDetail tModelDetail = this.uddiProxy.get_tModelDetail(this.uddiReference.getKey());
                    tModel = (TModel)tModelDetail.getTModelVector().elementAt(0);
                }
                if (this.verboseOption) {
                    System.err.println("    TModel specified or found in bindingTemplate - " + UDDIUtils.tModelToString(tModel));
                }
            }
            if (bindingTemplate == null) {
                this.setMissingInput(EntryType.getEntryType("bindingTemplate"));
            } else {
                entry = this.reporter.getReport().createEntry();
                entry.setEntryType(EntryType.getEntryType("bindingTemplate"));
                entry.setReferenceID(bindingTemplate.getBindingKey());
                entry.setEntryDetail(bindingTemplate);
                this.processAssertions(classPrefix, new EntryContext(entry, this.analyzerContext));
            }
            entry = this.reporter.getReport().createEntry();
            entry.setEntryType(EntryType.getEntryType("tModel"));
            entry.setReferenceID(tModel == null ? "[tModel]" : tModel.getTModelKey());
            entry.setEntryDetail(tModel);
            this.processAssertions(classPrefix, new EntryContext(entry, this.analyzerContext));
        }
        catch (Exception e) {
            if (e instanceof WSIException) {
                throw (WSIException)e;
            }
            throw new WSIException("An exception occurred while processing the discovery test assertions.", e);
        }
        this.cleanup();
    }

    @Override
    public String validate() throws WSIException {
        this.validateArtifact();
        return this.analyzerContext.getServiceReference().getWSDLLocation();
    }

    protected void setWSDLBinding(Binding binding) {
        String bindingName = binding == null ? null : binding.getQName().getLocalPart();
        String namespace = binding == null ? null : binding.getQName().getNamespaceURI();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        WSDLElement wsdlElement = serviceReference.getWSDLElement();
        if (wsdlElement == null) {
            wsdlElement = new WSDLElementImpl();
            wsdlElement.setName(bindingName);
            wsdlElement.setNamespace(namespace);
            wsdlElement.setType("binding");
        }
        serviceReference.setWSDLElement(wsdlElement);
        this.analyzerContext.setServiceReference(serviceReference);
    }

    protected void setWSDLLocation(String wsdlURL) {
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        serviceReference.setWSDLLocation(wsdlURL);
        this.analyzerContext.setServiceReference(serviceReference);
    }

    protected boolean isWsdlSpec(TModel tModel) {
        boolean tModelFound = false;
        CategoryBag categoryBag = null;
        Iterator categoryBagIterator = null;
        categoryBag = tModel.getCategoryBag();
        if (categoryBag != null) {
            categoryBagIterator = categoryBag.getKeyedReferenceVector().iterator();
            KeyedReference keyedReference = null;
            while (categoryBagIterator.hasNext() && !tModelFound) {
                keyedReference = (KeyedReference)categoryBagIterator.next();
                if (!keyedReference.getTModelKey().equalsIgnoreCase("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4") || !"wsdlSpec".equals(keyedReference.getKeyValue())) continue;
                tModelFound = true;
            }
        }
        return tModelFound;
    }

    protected String getOverviewURL(TModel tModel) {
        if (tModel != null && tModel.getOverviewDoc() != null && tModel.getOverviewDoc().getOverviewURL() != null) {
            return tModel.getOverviewDoc().getOverviewURL().getText();
        }
        return null;
    }

    protected String getWSDLLocation(String wsdlLocation) {
        int index = wsdlLocation.indexOf("#");
        if (index > -1) {
            wsdlLocation = wsdlLocation.substring(0, index);
        }
        return wsdlLocation;
    }

    protected WSDLDocument getWSDLDocument(String wsdlLocation) throws MalformedURLException, WSDLException {
        return new WSDLDocument(UDDIUtils.getWSDLLocation(wsdlLocation));
    }

    protected Binding getBinding(String overviewURL, WSDLDocument wsdlDocument) {
        int index;
        Binding[] bindings = wsdlDocument.getBindings();
        if (bindings == null || bindings.length == 0) {
            return null;
        }
        if (overviewURL != null && (index = overviewURL.indexOf("#")) > -1) {
            String nameAttribute = "@name=";
            int nameIndex = overviewURL.substring(index + 1).indexOf(nameAttribute);
            if (nameIndex > -1) {
                int firstQuoteIndex = index + 1 + nameIndex + nameAttribute.length();
                String quote = overviewURL.substring(firstQuoteIndex, firstQuoteIndex + 1);
                String urlPart = overviewURL.substring(firstQuoteIndex + 1);
                int nextQuoteIndex = urlPart.indexOf(quote);
                if (nextQuoteIndex > -1) {
                    String bindingName = urlPart.substring(0, nextQuoteIndex);
                    int i = 0;
                    while (i < bindings.length) {
                        if (bindingName.equals(bindings[i].getQName().getLocalPart())) {
                            return bindings[i];
                        }
                        ++i;
                    }
                }
            }
        }
        return bindings[0];
    }

    protected String categoryBagToString(CategoryBag categoryBag) {
        String toString = "";
        if (categoryBag != null) {
            Vector keyedReferenceList = null;
            keyedReferenceList = categoryBag.getKeyedReferenceVector();
            if (keyedReferenceList == null || keyedReferenceList.size() == 0) {
                toString = String.valueOf(toString) + "No KeyedReferences";
            } else {
                int count = 1;
                for (KeyedReference keyedReference : keyedReferenceList) {
                    toString = String.valueOf(toString) + "\n  [" + count++ + "] tModelKey: " + keyedReference.getTModelKey() + ", keyName: " + keyedReference.getKeyName() + ", keyValue: " + keyedReference.getKeyValue();
                }
            }
        } else {
            toString = "null";
        }
        return toString;
    }

    @Override
    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, EntryContext targetContext) {
        boolean match = false;
        if (testAssertion.getEntryTypeName().equals(targetContext.getEntry().getEntryType().getTypeName())) {
            match = true;
        }
        return match;
    }

    @Override
    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean notApplicable = false;
        return notApplicable;
    }

    @Override
    public boolean runTests() {
        return this.testable;
    }
}

