/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

public class RuntimeChangedListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent facetedProjectEvent) {
        IProjectFacetVersion pfv;
        IFacetedProjectWorkingCopy fpb = facetedProjectEvent.getWorkingCopy();
        if (fpb == null) {
            fpb = facetedProjectEvent.getProject();
        }
        if ((pfv = fpb.getProjectFacetVersion(JpaProject.FACET)) != null) {
            HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
            enablementVariables.put("jpaPlatform", this.getJpaPlatformId(fpb.getProject()));
            enablementVariables.put("jpaPlatformDescription", this.getJpaPlatformConfig(fpb.getProject()));
            LibraryInstallDelegate lp = new LibraryInstallDelegate((IFacetedProjectBase)fpb, pfv, enablementVariables);
            try {
                try {
                    lp.execute((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    JptJpaCorePlugin.instance().logError(ce);
                    lp.dispose();
                }
            }
            finally {
                lp.dispose();
            }
        }
    }

    protected String getJpaPlatformId(IProject project) {
        return JpaPreferences.getJpaPlatformID(project);
    }

    protected JpaPlatform.Config getJpaPlatformConfig(IProject project) {
        JpaPlatformManager jpaPlatformManager = this.getJpaPlatformManager();
        return jpaPlatformManager == null ? null : jpaPlatformManager.getJpaPlatformConfig(this.getJpaPlatformId(project));
    }

    protected JpaPlatformManager getJpaPlatformManager() {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getJpaPlatformManager();
    }

    protected JpaWorkspace getJpaWorkspace() {
        return (JpaWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JpaWorkspace.class);
    }
}

