/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.enablement.ingres.internal.ui.core.IngresSQLObjectItem;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.internal.core.AbstractControlConnection;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;

public class IngresControlConnection
extends AbstractControlConnection
implements IControlConnection {
    public IngresControlConnection(IControlConnectionManager manager, DatabaseIdentifier databaseIdentifier) {
        super(manager, databaseIdentifier);
    }

    protected IDBItem createDBItem(ProcIdentifier proc) {
        SQLObject obj = ModelUtil.findProceduralObject((ProcIdentifier)proc);
        if (obj != null) {
            return new IngresSQLObjectItem(proc, obj, this);
        }
        return null;
    }

    public void executeDDL(String[] src) throws SQLException {
        Connection con = this.getReusableConnection();
        boolean autoCommit = con.getAutoCommit();
        Statement stmt = con.createStatement();
        try {
            con.setAutoCommit(false);
            try {
                int i = 0;
                while (i < src.length) {
                    stmt.executeUpdate(src[i]);
                    ++i;
                }
                con.commit();
                this.refresh();
            }
            catch (SQLException ex) {
                con.rollback();
                throw ex;
            }
        }
        finally {
            stmt.close();
            con.setAutoCommit(autoCommit);
        }
    }
}

