/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class NodeValidationVisitor {
    private final short _nodeType;
    private final String _nodeName;
    private final Map _attributeVisitors;
    private final Map _elementVisitors;
    protected static final NodeValidationVisitor[] EMPTY_CHILDREN = new NodeValidationVisitor[0];

    public NodeValidationVisitor(short nodeType, String nodeName) {
        this._nodeType = nodeType;
        this._nodeName = nodeName;
        this._attributeVisitors = new HashMap();
        this._elementVisitors = new HashMap();
        NodeValidationVisitor[] childVisitors = this.getChildNodeValidators();
        int i = 0;
        while (i < childVisitors.length) {
            NodeValidationVisitor visitor = childVisitors[i];
            switch (visitor.getNodeType()) {
                case 2: {
                    this._attributeVisitors.put(visitor.getNodeName(), visitor);
                    break;
                }
                case 1: {
                    this._elementVisitors.put(visitor.getNodeName(), visitor);
                }
            }
            ++i;
        }
    }

    public final void validate(Node node, List messages, IFile file) {
        NodeValidationVisitor visitor;
        this.doValidate(node, messages, file);
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (attributes != null && i < attributes.getLength()) {
            Node attr = attributes.item(i);
            visitor = (NodeValidationVisitor)this._attributeVisitors.get(attr.getNodeName());
            if (visitor != null) {
                visitor.validate(attr, messages, file);
            }
            ++i;
        }
        i = 0;
        while (i < node.getChildNodes().getLength()) {
            Node child = node.getChildNodes().item(i);
            visitor = (NodeValidationVisitor)this._elementVisitors.get(child.getNodeName());
            if (visitor != null) {
                visitor.validate(child, messages, file);
            }
            ++i;
        }
    }

    protected abstract void doValidate(Node var1, List var2, IFile var3);

    protected abstract NodeValidationVisitor[] getChildNodeValidators();

    protected short getNodeType() {
        return this._nodeType;
    }

    protected String getNodeName() {
        return this._nodeName;
    }
}

