/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.ParameterType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseParameter;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.Domain;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;

public class SybaseASABaseParameterLoader {
    protected Routine routine;

    public SybaseASABaseParameterLoader(Routine routine) {
        this.routine = routine;
    }

    public final void loadParameterInfo(EList paramContaintmentList) {
        boolean deliver;
        block13: {
            deliver = this.routine.eDeliver();
            this.routine.eSetDeliver(false);
            paramContaintmentList.clear();
            Connection conn = ((ICatalogObject)this.routine).getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    Schema schema = this.routine.getSchema();
                    Database database = schema.getDatabase();
                    stmt = conn.prepareStatement("SELECT R.parm_id, TRIM(R.parm_name) as parm_name, TRIM(D.domain_name) as domain_name, R.width, R.scale, Y.type_name, R.parm_type, R.parm_mode_in, R.parm_mode_out FROM SYS.SYSPROCPARM R JOIN SYS.SYSDOMAIN D ON D.domain_id = R.domain_id LEFT OUTER JOIN SYS.SYSUSERTYPE Y ON Y.type_id = R.user_type JOIN SYS.SYSPROCEDURE P ON P.proc_id = R.proc_id JOIN SYS.SYSUSERPERMS U ON U.user_id = P.creator WHERE U.user_name like ? AND P.proc_name like ? AND R.parm_name like ? ORDER by R.parm_id");
                    stmt.setString(1, schema.getName());
                    stmt.setString(2, this.routine.getName());
                    stmt.setString(3, "%");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String parmName = rs.getString(2);
                        String domainName = rs.getString(3);
                        int width = rs.getInt(4);
                        int scale = rs.getInt(5);
                        String typeName = rs.getString(6);
                        int parmtype = rs.getInt(7);
                        boolean parmModeIn = rs.getString(8).equals("Y");
                        boolean parmModeOut = rs.getString(9).equals("Y");
                        SybaseASABaseParameter param = SybaseasabasesqlmodelFactory.eINSTANCE.createSybaseASABaseParameter();
                        param.setName(parmName);
                        if (typeName == null || typeName.equals("")) {
                            DatabaseDefinition dbDefn = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                            PredefinedDataType datatype = SybaseASACatalogUtils.getASAPredefinedType(width, scale, domainName, dbDefn);
                            param.setDataType((DataType)datatype);
                        } else {
                            Domain domain = SybaseASACatalogUtils.getSpecifiedUserDefinedDatatype(database, typeName);
                            param.setDataType((DataType)domain);
                        }
                        param.setParmType(this.getParameterType(parmtype));
                        ParameterMode mode = null;
                        if (parmModeIn && parmModeOut) {
                            mode = ParameterMode.INOUT_LITERAL;
                        } else if (parmModeIn && !parmModeOut) {
                            mode = ParameterMode.IN_LITERAL;
                        } else if (!parmModeIn && parmModeOut) {
                            mode = ParameterMode.OUT_LITERAL;
                        }
                        param.setMode(mode);
                        paramContaintmentList.add((Object)param);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.routine.eSetDeliver(deliver);
    }

    private ParameterType getParameterType(int iType) {
        switch (iType) {
            case 0: {
                return ParameterType.VARIABLE_LITERAL;
            }
            case 1: {
                return ParameterType.RESULT_LITERAL;
            }
            case 2: {
                return ParameterType.SQLSTATE_LITERAL;
            }
            case 3: {
                return ParameterType.SQLCODE_LITERAL;
            }
        }
        return ParameterType.RETURN_LITERAL;
    }
}

