/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.net.URI;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticContextAdapter;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DynamicContextAdapter
implements org.eclipse.wst.xml.xpath2.api.DynamicContext {
    private final DynamicContext dc;
    private StaticContextAdapter sca;

    public DynamicContextAdapter(DynamicContext dc) {
        this.dc = dc;
        this.sca = new StaticContextAdapter(dc);
    }

    @Override
    public Node getLimitNode() {
        return null;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence getVariable(javax.xml.namespace.QName name) {
        Object var = this.dc.get_variable(new QName(name));
        if (var == null) {
            return ResultBuffer.EMPTY;
        }
        if (var instanceof org.eclipse.wst.xml.xpath2.api.ResultSequence) {
            return (org.eclipse.wst.xml.xpath2.api.ResultSequence)var;
        }
        return ResultBuffer.wrap((Item)var);
    }

    @Override
    public URI resolveUri(String uri) {
        return this.dc.resolve_uri(uri);
    }

    @Override
    public GregorianCalendar getCurrentDateTime() {
        return this.dc.current_date_time();
    }

    @Override
    public Duration getTimezoneOffset() {
        XSDuration tz = this.dc.tz();
        try {
            return DatatypeFactory.newInstance().newDuration(!tz.negative(), 0, 0, 0, tz.hours(), tz.minutes(), 0);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document getDocument(URI uri) {
        ResultSequence rs = this.dc.get_doc(uri);
        if (rs == null || rs.empty()) {
            return null;
        }
        return ((DocType)rs.get(0)).value();
    }

    @Override
    public Map<String, List<Document>> getCollections() {
        return this.dc.get_collections();
    }

    @Override
    public List<Document> getDefaultCollection() {
        return this.getCollections().get("http://www.w3.org/2005/xpath-functions/collection/default");
    }

    @Override
    public CollationProvider getCollationProvider() {
        return this.sca.getCollationProvider();
    }
}

