/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contenttype;

import java.util.Locale;

public class EncodingGuesser {
    private static final int ASCII = 0;
    private static final int ASCII_IN = 8;
    private static final int EUC_HALFKANA = 6;
    private static final int EUC_JP = 3;
    private static final int ISO2022_JP = 4;
    private static final int JIS_HALFKANA = 7;
    private static final byte KT_EUC1 = 64;
    private static final byte KT_EUC2 = -128;
    private static final byte KT_JIN = 1;
    private static final byte KT_JOUT = 2;
    private static final byte KT_SFT1 = 16;
    private static final byte KT_SFT2 = 32;
    private static final byte[] ktype;
    private static final int SHIFT_JIS = 2;
    private static final int SJIS_HALFKANA = 5;
    private static final int UNKNOWN = -1;
    private static final boolean IS_GUESSING_ENABLED;

    static {
        byte[] byArray = new byte[256];
        byArray[33] = 8;
        byArray[34] = 8;
        byArray[35] = 8;
        byArray[36] = 9;
        byArray[37] = 8;
        byArray[38] = 8;
        byArray[39] = 8;
        byArray[40] = 8;
        byArray[41] = 8;
        byArray[42] = 8;
        byArray[43] = 8;
        byArray[44] = 8;
        byArray[45] = 8;
        byArray[46] = 8;
        byArray[47] = 8;
        byArray[48] = 8;
        byArray[49] = 8;
        byArray[50] = 8;
        byArray[51] = 8;
        byArray[52] = 8;
        byArray[53] = 8;
        byArray[54] = 8;
        byArray[55] = 8;
        byArray[56] = 8;
        byArray[57] = 8;
        byArray[58] = 8;
        byArray[59] = 8;
        byArray[60] = 8;
        byArray[61] = 8;
        byArray[62] = 8;
        byArray[63] = 8;
        byArray[64] = 41;
        byArray[65] = 40;
        byArray[66] = 43;
        byArray[67] = 40;
        byArray[68] = 40;
        byArray[69] = 40;
        byArray[70] = 40;
        byArray[71] = 40;
        byArray[72] = 42;
        byArray[73] = 40;
        byArray[74] = 42;
        byArray[75] = 40;
        byArray[76] = 40;
        byArray[77] = 40;
        byArray[78] = 40;
        byArray[79] = 40;
        byArray[80] = 40;
        byArray[81] = 40;
        byArray[82] = 40;
        byArray[83] = 40;
        byArray[84] = 40;
        byArray[85] = 40;
        byArray[86] = 40;
        byArray[87] = 40;
        byArray[88] = 40;
        byArray[89] = 40;
        byArray[90] = 40;
        byArray[91] = 40;
        byArray[92] = 40;
        byArray[93] = 40;
        byArray[94] = 40;
        byArray[95] = 40;
        byArray[96] = 40;
        byArray[97] = 40;
        byArray[98] = 40;
        byArray[99] = 40;
        byArray[100] = 40;
        byArray[101] = 40;
        byArray[102] = 40;
        byArray[103] = 40;
        byArray[104] = 40;
        byArray[105] = 40;
        byArray[106] = 40;
        byArray[107] = 40;
        byArray[108] = 40;
        byArray[109] = 40;
        byArray[110] = 40;
        byArray[111] = 40;
        byArray[112] = 40;
        byArray[113] = 40;
        byArray[114] = 40;
        byArray[115] = 40;
        byArray[116] = 40;
        byArray[117] = 40;
        byArray[118] = 40;
        byArray[119] = 40;
        byArray[120] = 40;
        byArray[121] = 40;
        byArray[122] = 40;
        byArray[123] = 40;
        byArray[124] = 40;
        byArray[125] = 40;
        byArray[126] = 40;
        byArray[128] = 32;
        byArray[129] = 48;
        byArray[130] = 48;
        byArray[131] = 48;
        byArray[132] = 48;
        byArray[133] = 48;
        byArray[134] = 48;
        byArray[135] = 48;
        byArray[136] = 48;
        byArray[137] = 48;
        byArray[138] = 48;
        byArray[139] = 48;
        byArray[140] = 48;
        byArray[141] = 48;
        byArray[142] = 48;
        byArray[143] = 48;
        byArray[144] = 48;
        byArray[145] = 48;
        byArray[146] = 48;
        byArray[147] = 48;
        byArray[148] = 48;
        byArray[149] = 48;
        byArray[150] = 48;
        byArray[151] = 48;
        byArray[152] = 48;
        byArray[153] = 48;
        byArray[154] = 48;
        byArray[155] = 48;
        byArray[156] = 48;
        byArray[157] = 48;
        byArray[158] = 48;
        byArray[159] = 48;
        byArray[160] = 32;
        byArray[161] = -32;
        byArray[162] = -32;
        byArray[163] = -32;
        byArray[164] = -32;
        byArray[165] = -32;
        byArray[166] = -32;
        byArray[167] = -32;
        byArray[168] = -32;
        byArray[169] = -32;
        byArray[170] = -32;
        byArray[171] = -32;
        byArray[172] = -32;
        byArray[173] = -32;
        byArray[174] = -32;
        byArray[175] = -32;
        byArray[176] = -32;
        byArray[177] = -32;
        byArray[178] = -32;
        byArray[179] = -32;
        byArray[180] = -32;
        byArray[181] = -32;
        byArray[182] = -32;
        byArray[183] = -32;
        byArray[184] = -32;
        byArray[185] = -32;
        byArray[186] = -32;
        byArray[187] = -32;
        byArray[188] = -32;
        byArray[189] = -32;
        byArray[190] = -32;
        byArray[191] = -32;
        byArray[192] = -32;
        byArray[193] = -32;
        byArray[194] = -32;
        byArray[195] = -32;
        byArray[196] = -32;
        byArray[197] = -32;
        byArray[198] = -32;
        byArray[199] = -32;
        byArray[200] = -32;
        byArray[201] = -32;
        byArray[202] = -32;
        byArray[203] = -32;
        byArray[204] = -32;
        byArray[205] = -32;
        byArray[206] = -32;
        byArray[207] = -32;
        byArray[208] = -32;
        byArray[209] = -32;
        byArray[210] = -32;
        byArray[211] = -32;
        byArray[212] = -32;
        byArray[213] = -32;
        byArray[214] = -32;
        byArray[215] = -32;
        byArray[216] = -32;
        byArray[217] = -32;
        byArray[218] = -32;
        byArray[219] = -32;
        byArray[220] = -32;
        byArray[221] = -32;
        byArray[222] = -32;
        byArray[223] = -32;
        byArray[224] = -16;
        byArray[225] = -16;
        byArray[226] = -16;
        byArray[227] = -16;
        byArray[228] = -16;
        byArray[229] = -16;
        byArray[230] = -16;
        byArray[231] = -16;
        byArray[232] = -16;
        byArray[233] = -16;
        byArray[234] = -16;
        byArray[235] = -16;
        byArray[236] = -16;
        byArray[237] = -16;
        byArray[238] = -16;
        byArray[239] = -16;
        byArray[240] = -16;
        byArray[241] = -16;
        byArray[242] = -16;
        byArray[243] = -16;
        byArray[244] = -16;
        byArray[245] = -16;
        byArray[246] = -16;
        byArray[247] = -16;
        byArray[248] = -16;
        byArray[249] = -16;
        byArray[250] = -16;
        byArray[251] = -16;
        byArray[252] = -16;
        byArray[253] = -64;
        byArray[254] = -64;
        ktype = byArray;
        IS_GUESSING_ENABLED = EncodingGuesser.isGuessingEnabled();
    }

    private static String convertToIANAEncodingName(int code) {
        String encoding = null;
        switch (code) {
            case 2: 
            case 5: {
                encoding = "Shift_JIS";
                break;
            }
            case 3: 
            case 6: {
                encoding = "EUC-JP";
                break;
            }
            case 4: 
            case 7: {
                encoding = "ISO-2022-JP";
            }
        }
        return encoding;
    }

    public static boolean canGuess() {
        String jp_ctype;
        if (!IS_GUESSING_ENABLED) {
            return false;
        }
        String system_ctype = Locale.getDefault().getLanguage();
        return system_ctype.compareTo(jp_ctype = Locale.JAPANESE.getLanguage()) == 0;
    }

    private static boolean isGuessingEnabled() {
        String value = System.getProperty("org.eclipse.wst.html.encoding.guess");
        return value == null || Boolean.valueOf(value) != false;
    }

    public static String guessEncoding(byte[] target, int length) {
        int code = -1;
        if (EncodingGuesser.canGuess()) {
            code = 0;
            int pos = 0;
            while (code == 0 && length > 0) {
                int ch1 = target[pos];
                int ch2 = length >= 2 ? target[pos + 1] : 0;
                int ch3 = length >= 3 ? target[pos + 2] : 0;
                code = EncodingGuesser.guessJapaneseKanjiCode(ch1 &= 0xFF, ch2 &= 0xFF, ch3 &= 0xFF, 0);
                ++pos;
                --length;
            }
            switch (code) {
                case 4: 
                case 7: {
                    code = 4;
                    break;
                }
                case 3: {
                    code = 3;
                    break;
                }
                case 2: 
                case 5: {
                    code = 2;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return EncodingGuesser.convertToIANAEncodingName(code);
    }

    private static int guessJapaneseKanjiCode(int ch1, int ch2, int ch3, int halfkana_flag) {
        boolean euc_hankaku_flag;
        boolean sjis_hankaku_flag = (halfkana_flag & 1) != 0;
        boolean bl = euc_hankaku_flag = (halfkana_flag & 2) != 0;
        if (ch1 == 0) {
            return -1;
        }
        if (sjis_hankaku_flag && ch1 >= 161 && ch1 <= 223) {
            return 5;
        }
        if (euc_hankaku_flag && ch1 == 142 && ch2 >= 161 && ch2 <= 223) {
            return 6;
        }
        if ((ktype[ch1] & 0x10) != 0 && (ktype[ch2] & 0x20) != 0) {
            return 2;
        }
        if ((ktype[ch1] & 0x40) != 0 && (ktype[ch2] & 0xFFFFFF80) != 0) {
            return 3;
        }
        if (ch1 == 27 && (ktype[ch2] & 1) != 0) {
            return 4;
        }
        if (ch1 >= 161 && ch1 <= 223) {
            return 5;
        }
        if (ch1 == 27 && ch2 == 40 && ch3 == 73) {
            return 7;
        }
        if (ch1 == 27 && ch2 == 40 && (ktype[ch3] & 2) != 0) {
            return 8;
        }
        return 0;
    }
}

