/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.resolvers;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DefaultReferenceResolver
implements IReferenceResolver {
    @Override
    public boolean canResolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        return false;
    }

    @Override
    public boolean canResolve(IVirtualReference reference) {
        return false;
    }

    @Override
    public IVirtualReference resolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        IVirtualComponent targetComponent = null;
        IProject targetProject = null;
        URI uri = referencedComponent.getHandle();
        if (uri == null) {
            return null;
        }
        boolean isClassPathURI = ModuleURIUtil.isClassPathURI(uri);
        if (!isClassPathURI) {
            try {
                targetProject = StructureEdit.getContainingProject(uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createComponent(targetProject);
        } else {
            String archiveType = "";
            String archiveName = "";
            try {
                archiveType = ModuleURIUtil.getArchiveType(uri);
                archiveName = ModuleURIUtil.getArchiveName(uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createArchiveComponent(context.getProject(), archiveType + "/" + archiveName);
        }
        VirtualReference vRef = new VirtualReference(context, targetComponent, referencedComponent.getRuntimePath(), referencedComponent.getDependencyType().getValue());
        vRef.setArchiveName(referencedComponent.getArchiveName());
        return vRef;
    }

    @Override
    public ReferencedComponent resolve(IVirtualReference reference) {
        IVirtualComponent referencedComponent = reference.getReferencedComponent();
        ReferencedComponent refComp = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
        refComp.setRuntimePath(reference.getRuntimePath());
        refComp.setDependencyType(DependencyType.get(reference.getDependencyType()));
        refComp.setArchiveName(reference.getArchiveName());
        if (referencedComponent != null) {
            if (!referencedComponent.isBinary()) {
                refComp.setHandle(ModuleURIUtil.fullyQualifyURI(referencedComponent.getProject()));
            } else {
                refComp.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI(referencedComponent.getName()));
            }
        }
        return refComp;
    }
}

