/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.formatter.core.CodeFormatterVisitor;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.php.internal.core.format.IFormatterProcessorFactory;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.formatter.core.HtmlFormatterForPHPCode;
import org.eclipse.php.internal.formatter.core.Logger;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.osgi.service.prefs.Preferences;

public class PHPCodeFormatter
implements IContentFormatter,
IFormatterProcessorFactory {
    public void format(IDocument document, IRegion region) {
        block13: {
            IStructuredTextUndoManager undoManager = null;
            IStructuredModel structuredModel = null;
            try {
                if (!(document instanceof IStructuredDocument)) break block13;
                IStructuredDocument structuredDocument = (IStructuredDocument)document;
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                IProject project = null;
                if (structuredModel != null) {
                    project = this.getProject(structuredModel);
                }
                if (project == null) {
                    Logger.logException(new IllegalStateException("Cann't resolve file name"));
                    return;
                }
                try {
                    List<ReplaceEdit> changes;
                    undoManager = structuredDocument.getUndoManager();
                    undoManager.beginRecording((Object)this, "php format document", "format PHP document", 0, document.getLength());
                    HtmlFormatterForPHPCode htmlFormatter = new HtmlFormatterForPHPCode();
                    try {
                        htmlFormatter.formatDocument(document, region.getOffset(), region.getLength());
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                    ICodeFormattingProcessor codeFormatterVisitor = this.getCodeFormattingProcessor(project, document, region);
                    if (codeFormatterVisitor instanceof CodeFormatterVisitor && (changes = ((CodeFormatterVisitor)codeFormatterVisitor).getChanges()).size() > 0) {
                        this.replaceAll(document, changes, structuredModel);
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            finally {
                if (undoManager != null) {
                    undoManager.endRecording((Object)this);
                }
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
    }

    public ICodeFormattingProcessor getCodeFormattingProcessor(IDocument document, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags, IRegion region) throws Exception {
        IProject project = this.getProject(document);
        return this.getCodeFormattingProcessor(project, document, phpVersion, useASPTags, useShortTags, region);
    }

    public ICodeFormattingProcessor getCodeFormattingProcessor(IProject project, IDocument document, IRegion region) throws Exception {
        return this.getCodeFormattingProcessor(project, document, ProjectOptions.getPHPVersion((IProject)project), ProjectOptions.isSupportingASPTags((IProject)project), ProjectOptions.useShortTags((IProject)project), region);
    }

    private ICodeFormattingProcessor getCodeFormattingProcessor(IProject project, IDocument document, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags, IRegion region) throws Exception {
        CodeFormatterPreferences fCodeFormatterPreferences = PHPCodeFormatter.getPreferences(project);
        CodeFormatterVisitor codeFormattingProcessor = new CodeFormatterVisitor(document, fCodeFormatterPreferences, PHPModelUtils.getLineSeparator((IProject)project), phpVersion, useASPTags, useShortTags, region);
        return codeFormattingProcessor;
    }

    private IProject getProject(IDocument document) {
        IProject project = null;
        IStructuredModel structuredModel = null;
        if (document instanceof IStructuredDocument) {
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                project = this.getProject(structuredModel);
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return project;
    }

    private final IProject getProject(IStructuredModel doModelForPHP) {
        IFile file;
        String id;
        if (doModelForPHP != null && (id = doModelForPHP.getId()) != null && (file = this.getFile(id)) != null) {
            return file.getProject();
        }
        return null;
    }

    private IFile getFile(String id) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(id));
    }

    private void replaceAll(IDocument document, List<ReplaceEdit> changes, IStructuredModel domModelForPHP) throws MalformedTreeException, BadLocationException {
        MultiTextEdit multiEdit = new MultiTextEdit();
        multiEdit.addChildren((TextEdit[])changes.toArray(new ReplaceEdit[0]));
        if (RewriteSessionEditProcessor.isLargeEdit((TextEdit)multiEdit)) {
            Document finalDocument = new Document(document.get());
            multiEdit.apply((IDocument)finalDocument);
            multiEdit = new ReplaceEdit(0, document.getLength(), finalDocument.get());
        }
        Map partitioners = null;
        try {
            if (multiEdit.getChildrenSize() > 20) {
                partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
            }
            RewriteSessionEditProcessor editProcessor = new RewriteSessionEditProcessor(document, (TextEdit)multiEdit, 3);
            editProcessor.performEdits();
        }
        finally {
            if (partitioners != null) {
                TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
            }
        }
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        return null;
    }

    public static CodeFormatterPreferences getPreferences(IProject project) throws Exception {
        IEclipsePreferences node = null;
        if (project != null) {
            ProjectScope scope = new ProjectScope(project);
            node = scope.getNode("org.eclipse.php.formatter.core");
        }
        if (node == null || node.get("formatterProfile", null) == null) {
            IScopeContext context = InstanceScope.INSTANCE;
            node = context.getNode("org.eclipse.php.formatter.core");
        }
        HashMap<String, Object> p = new HashMap<String, Object>(CodeFormatterPreferences.getDefaultPreferences().getMap());
        if (node != null && node.keys().length > 0) {
            Set propertiesNames = p.keySet();
            for (String property : propertiesNames) {
                String value = node.get(property, null);
                if (value == null) continue;
                p.put(property, value);
            }
        } else {
            IPreferencesService service = Platform.getPreferencesService();
            String[] lookup = service.getLookupOrder("org.eclipse.php.formatter.core", null);
            Preferences[] nodes = new Preferences[lookup.length];
            int i = 0;
            while (i < lookup.length) {
                nodes[i] = service.getRootNode().node(lookup[i]).node("org.eclipse.php.formatter.core");
                ++i;
            }
            for (String property : p.keySet()) {
                String value = service.get(property, null, nodes);
                if (value == null) continue;
                p.put(property, value);
            }
        }
        return new CodeFormatterPreferences(p);
    }
}

