/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;

public class DTDNodeSnippetContext
implements IXMLSnippetContext {
    public static IXMLSnippetContext DEFAULT_CONTEXT = new DTDNodeSnippetContext();

    @Override
    public boolean isMatch(ICompletionRequest request, Map<String, String> model) {
        DOMNode node = request.getNode();
        if (node == null) {
            return false;
        }
        DOMDocument document = node.getOwnerDocument();
        if (document.isDTD()) {
            return true;
        }
        DOMDocumentType docType = null;
        if (node.isDoctype()) {
            docType = (DOMDocumentType)node;
        } else if (node.getParentNode() != null && node.getParentNode().isDoctype()) {
            docType = (DOMDocumentType)node.getParentNode();
        }
        if (docType == null) {
            return false;
        }
        return document.isWithinInternalDTD(request.getOffset());
    }
}

