"use strict";
exports.__esModule = true;
exports.FormatAtForwardOrAtUse = void 0;
var format_convert_1 = require("./format.convert");
var utility_1 = require("../utility");
var logger_1 = require("../logger");
function FormatAtForwardOrAtUse(line, STATE) {
    if (utility_1.convertLine(line, STATE)) {
        var convertRes = format_convert_1.convertScssOrCss(line.get(), STATE);
        line.set(convertRes.text);
    }
    line.set(line.get().trimStart());
    logger_1.PushDebugInfo({
        title: '@forward or @use',
        lineNumber: STATE.currentLine,
        oldLineText: STATE.lines[STATE.currentLine],
        newLineText: line.get(),
        debug: STATE.CONFIG.debug
    });
    return line.get();
}
exports.FormatAtForwardOrAtUse = FormatAtForwardOrAtUse;
