/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.RefAdvancerWalk;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexWriter;
import org.eclipse.jgit.internal.storage.midx.PackIndexMerger;
import org.eclipse.jgit.internal.storage.pack.PackBitmapCalculator;
import org.eclipse.jgit.internal.storage.pack.PackBitmapIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.pack.PackConfig;

public class DfsMidxWriter {
    private DfsMidxWriter() {
    }

    public static DfsPackDescription writeMidx(ProgressMonitor pm, DfsObjDatabase objdb, List<DfsPackFile> packs, @Nullable DfsPackDescription base) throws IOException {
        return DfsMidxWriter.writeMidx(pm, objdb, packs, base, new PackConfig(objdb.getRepository()));
    }

    public static DfsPackDescription writeMidx(ProgressMonitor pm, DfsObjDatabase objdb, List<DfsPackFile> packs, @Nullable DfsPackDescription base, PackConfig packConfig) throws IOException {
        PackIndexMerger.Builder dataBuilder = PackIndexMerger.builder();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (DfsReader ctx = objdb.newReader();){
            for (DfsPackFile pack : packs) {
                dataBuilder.addPack(pack.getPackDescription().getPackName(), pack.getPackIndex(ctx));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        DfsPackDescription midxPackDesc = objdb.newPack(DfsObjDatabase.PackSource.GC);
        throwable2 = null;
        Object var8_11 = null;
        try (DfsOutputStream out = objdb.writeFile(midxPackDesc, PackExt.MULTI_PACK_INDEX);){
            MultiPackIndexWriter w = new MultiPackIndexWriter();
            MultiPackIndexWriter.Result result = w.write(pm, out, dataBuilder.build());
            midxPackDesc.addFileExt(PackExt.MULTI_PACK_INDEX);
            midxPackDesc.setFileSize(PackExt.MULTI_PACK_INDEX, result.bytesWritten());
            midxPackDesc.setObjectCount(result.objectCount());
            Map byName = packs.stream().map(DfsPackFile::getPackDescription).collect(Collectors.toMap(DfsPackDescription::getPackName, Function.identity()));
            List coveredPacks = result.packNames().stream().map(byName::get).collect(Collectors.toList());
            midxPackDesc.setCoveredPacks(coveredPacks);
            if (base != null) {
                midxPackDesc.setMultiPackIndexBase(base);
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        if (base == null && midxPackDesc.getCoveredPacks().size() > 1) {
            DfsMidxWriter.createAndAttachBitmaps(objdb.getRepository(), midxPackDesc, packConfig);
        }
        return midxPackDesc;
    }

    private static void createAndAttachBitmaps(DfsRepository db, DfsPackDescription desc, PackConfig cfg) throws IOException {
        DfsObjDatabase objdb = db.getObjectDatabase();
        DfsPackFileMidx midxPack = db.getObjectDatabase().createDfsPackFileMidx(DfsBlockCache.getInstance(), desc, new ArrayList<DfsPackDescription>());
        List<ObjectId> allHeads = db.getRefDatabase().getRefsByPrefix("refs/heads/").stream().map(r -> r.getObjectId()).filter(Objects::nonNull).toList();
        if (allHeads.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (DfsReader ctx = objdb.newReader();){
            RefAdvancerWalk adv = new RefAdvancerWalk(db, c -> midxPack.hasObject(ctx, c));
            Set<RevCommit> inPack = adv.advance(allHeads);
            byte[] checksum = midxPack.getChecksum(ctx);
            PackBitmapIndexBuilder writeBitmaps = new PackBitmapIndexBuilder(midxPack.getLocalObjects(ctx));
            int commitCount = writeBitmaps.getCommits().cardinality();
            PackBitmapCalculator calculator = new PackBitmapCalculator(cfg);
            calculator.calculate(ctx, NullProgressMonitor.INSTANCE, commitCount, inPack, new HashSet(), writeBitmaps);
            PackBitmapIndexWriter pbiWriter = db.getObjectDatabase().getPackBitmapIndexWriter(desc);
            pbiWriter.write(writeBitmaps, checksum);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

