/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools.change;

import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.properties.Document;
import aQute.bnd.properties.IDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class BuildToBndChange
extends Change {
    private static final String DS_CONTENT_TYPE_ID = "org.eclipse.pde.ds.core.content-type";
    private final IBuildModel model;
    private final IProject project;
    private final IFile instructionfile;

    public BuildToBndChange(IProject project, IBuildModel model, IFile instructionfile) {
        this.project = project;
        this.model = model;
        this.instructionfile = instructionfile;
    }

    public String getName() {
        return PDEUIMessages.ProjectUpdateChange_convert_build_to_bnd;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.model != null) {
            BndEditModel editModel;
            Document document;
            block17: {
                if (this.instructionfile.exists()) {
                    try {
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (InputStream contents = this.instructionfile.getContents();){
                            document = new Document(new String(contents.readAllBytes(), StandardCharsets.UTF_8));
                            break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new CoreException(Status.error((String)"Reading file content failed", (Throwable)e));
                    }
                }
                document = new Document("");
            }
            try {
                editModel = new BndEditModel((IDocument)document);
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)"Reading document failed", (Throwable)e));
            }
            IBuild build = this.model.getBuild();
            this.processBinIncludes(build, editModel);
            this.processAdditionalBundles(build, editModel);
            this.processExtraClasspath(build, editModel);
            this.processJars(build, editModel);
            editModel.saveChangesTo((IDocument)document);
            if (this.instructionfile.exists()) {
                this.instructionfile.setContents((InputStream)new ByteArrayInputStream(document.get().getBytes(StandardCharsets.UTF_8)), true, true, pm);
            } else {
                this.instructionfile.create((InputStream)new ByteArrayInputStream(document.get().getBytes(StandardCharsets.UTF_8)), true, pm);
            }
        }
        return null;
    }

    private void processJars(IBuild build, BndEditModel editModel) {
        ArrayList<CallSite> includeResource = new ArrayList<CallSite>(editModel.getIncludeResource());
        ArrayList<String> makeJars = new ArrayList<String>();
        IBuildEntry[] iBuildEntryArray = build.getBuildEntries();
        int n = iBuildEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            String jarName;
            IBuildEntry buildEntry = iBuildEntryArray[n2];
            String name = buildEntry.getName();
            if (name.startsWith("source.") && !(jarName = name.substring("source.".length())).equals(".")) {
                String outputFolder = Optional.ofNullable(build.getEntry("output." + jarName)).stream().flatMap(entry -> Arrays.stream(entry.getTokens())).findFirst().orElseGet(() -> this.getOutputFolderFromJava(buildEntry.getTokens()));
                String outputForInclude = BuildToBndChange.getIncludeResourceForBinInclude(jarName);
                includeResource.remove(outputForInclude);
                includeResource.add((CallSite)((Object)(outputForInclude + ";lib:=true")));
                makeJars.add(String.format("%s;type=jar;input=\"%s\"", jarName, outputFolder));
            }
            ++n2;
        }
        if (!makeJars.isEmpty()) {
            editModel.genericSet("-includeresource", includeResource);
            editModel.genericSet("-make", (Object)makeJars.stream().collect(Collectors.joining(", ")));
        }
    }

    private String getOutputFolderFromJava(String[] sourceTokens) {
        try {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IPath outputLocation = javaProject.getOutputLocation();
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    String[] stringArray = sourceTokens;
                    int n3 = sourceTokens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String token = stringArray[n4];
                        if (IPath.fromPortableString((String)token).equals((Object)entry.getPath())) {
                            IPath srcLoc = entry.getOutputLocation();
                            if (srcLoc == null) break;
                            outputLocation = srcLoc;
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return this.project.getWorkspace().getRoot().getFolder(outputLocation).getProjectRelativePath().toPortableString();
        }
        catch (CoreException e) {
            return "bin/";
        }
    }

    private void processBinIncludes(IBuild build, BndEditModel editModel) {
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            return;
        }
        List<String> list = Arrays.stream(entry.getTokens()).filter(str -> this.isCustomResource((String)str, build)).map(str -> BuildToBndChange.getIncludeResourceForBinInclude(str)).toList();
        editModel.genericSet("-includeresource", list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCustomResource(String str, IBuild build) {
        IResource[] members2;
        IFolder folder;
        if (".".equals(str)) {
            return false;
        }
        if ("META-INF/MANIFEST.MF".equals(str)) {
            return false;
        }
        if ("META-INF/".equals(str) || "META-INF".equals(str)) {
            folder = this.project.getFolder(str);
            try {
                members2 = folder.members();
                if (members2.length == 0) {
                    return false;
                }
                if (members2.length == 1 && "MANIFEST.MF".equals(members2[0].getName())) {
                    return false;
                }
            }
            catch (CoreException members2) {
                // empty catch block
            }
        }
        if ("OSGI-INF/".equals(str) || "OSGI-INF".equals(str)) {
            folder = this.project.getFolder(str);
            try {
                members2 = folder.members();
                int cfr_ignored_0 = members2.length;
                IResource[] iResourceArray = members2;
                int n = members2.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (!member.getName().startsWith(".")) {
                        if (member instanceof IFile) {
                            IContentType contentType;
                            IFile file = (IFile)member;
                            IContentDescription description = file.getContentDescription();
                            if (description == null || (contentType = description.getContentType()) == null || !DS_CONTENT_TYPE_ID.equals(contentType.getId())) {
                                return true;
                            }
                        } else if (member instanceof IFolder) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return true;
    }

    private void processAdditionalBundles(IBuild build, BndEditModel editModel) {
        IBuildEntry entry = build.getEntry("additional.bundles");
        if (entry == null) {
            return;
        }
        Arrays.stream(entry.getTokens()).forEach(additional -> editModel.addPath(new VersionedClause(additional), "-buildpath"));
    }

    private void processExtraClasspath(IBuild build, BndEditModel editModel) {
        IBuildEntry entry = build.getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        editModel.setClassPath(Arrays.asList(entry.getTokens()));
    }

    public Object getModifiedElement() {
        return this.instructionfile;
    }

    private static String getIncludeResourceForBinInclude(String str) {
        return str.contains("/") ? String.format("%s=%s", str, str) : str;
    }
}

