"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryDocument = exports.tempDocVersion = void 0;
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
/**
 * Represents a temporary version of a document.
 *
 * This indicates that the document should not be cached or reuse cached results.
 */
exports.tempDocVersion = -1;
class InMemoryDocument {
    version;
    #doc;
    $uri;
    uri;
    constructor(uri, contents, version = 0) {
        this.version = version;
        this.$uri = uri;
        this.uri = uri.toString();
        this.#doc = vscode_languageserver_textdocument_1.TextDocument.create(this.uri, 'markdown', version, contents);
    }
    get lineCount() {
        return this.#doc.lineCount;
    }
    positionAt(offset) {
        return this.#doc.positionAt(offset);
    }
    offsetAt(position) {
        return this.#doc.offsetAt(position);
    }
    getText(range) {
        return this.#doc.getText(range);
    }
    replaceContents(newContent) {
        this.#update([{ text: newContent }]);
        return this;
    }
    applyEdits(textEdits) {
        this.#update(textEdits.map(x => ({ range: x.range, text: x.newText })));
        return this;
    }
    previewEdits(textEdits) {
        return vscode_languageserver_textdocument_1.TextDocument.applyEdits(this.#doc, textEdits);
    }
    #update(changes) {
        // Temp docs always share the same version
        const newVersion = this.version < 0 ? this.version : this.version + 1;
        this.version = newVersion;
        vscode_languageserver_textdocument_1.TextDocument.update(this.#doc, changes, newVersion);
    }
}
exports.InMemoryDocument = InMemoryDocument;
//# sourceMappingURL=inMemoryDocument.js.map