/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.util;

import java.util.ArrayList;
import java.util.List;

public class ThreadPool {
    private final ThreadGroup threadGroup;
    private final int maxSize;
    private final List waitingThreads = new ArrayList();
    private final List runningThreads = new ArrayList();
    private final List waitingTasks = new ArrayList();
    private int num;

    public ThreadPool(int pMaxSize, String pName) {
        this.maxSize = pMaxSize;
        this.threadGroup = new ThreadGroup(pName);
    }

    private synchronized void remove(Poolable pPoolable) {
        this.runningThreads.remove(pPoolable);
        this.waitingThreads.remove(pPoolable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repool(Poolable pPoolable) {
        boolean discarding = false;
        Task task = null;
        Poolable poolable = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.runningThreads.remove(pPoolable)) {
                if (this.maxSize != 0 && this.runningThreads.size() + this.waitingThreads.size() >= this.maxSize) {
                    discarding = true;
                } else {
                    this.waitingThreads.add(pPoolable);
                    if (this.waitingTasks.size() > 0) {
                        task = (Task)this.waitingTasks.remove(this.waitingTasks.size() - 1);
                        poolable = this.getPoolable(task, false);
                    }
                }
            } else {
                discarding = true;
            }
            if (discarding) {
                this.remove(pPoolable);
            }
        }
        if (poolable != null) {
            poolable.start(task);
        }
        if (discarding) {
            pPoolable.shutdown();
        }
    }

    public boolean startTask(Task pTask) {
        Poolable poolable = this.getPoolable(pTask, false);
        if (poolable == null) {
            return false;
        }
        poolable.start(pTask);
        return true;
    }

    private synchronized Poolable getPoolable(Task pTask, boolean pQueue) {
        if (this.maxSize != 0 && this.runningThreads.size() >= this.maxSize) {
            if (pQueue) {
                this.waitingTasks.add(pTask);
            }
            return null;
        }
        Poolable poolable = this.waitingThreads.size() > 0 ? (Poolable)this.waitingThreads.remove(this.waitingThreads.size() - 1) : new Poolable(this.threadGroup, this.num++);
        this.runningThreads.add(poolable);
        return poolable;
    }

    public boolean addTask(Task pTask) {
        Poolable poolable = this.getPoolable(pTask, true);
        if (poolable != null) {
            poolable.start(pTask);
            return true;
        }
        return false;
    }

    public synchronized void shutdown() {
        Poolable poolable;
        while (!this.waitingThreads.isEmpty()) {
            poolable = (Poolable)this.waitingThreads.remove(this.waitingThreads.size() - 1);
            poolable.shutdown();
        }
        while (!this.runningThreads.isEmpty()) {
            poolable = (Poolable)this.runningThreads.remove(this.runningThreads.size() - 1);
            poolable.shutdown();
        }
    }

    public int getMaxThreads() {
        return this.maxSize;
    }

    public synchronized int getNumThreads() {
        return this.num;
    }

    public static interface InterruptableTask
    extends Task {
        public void shutdown() throws Throwable;
    }

    private class Poolable {
        private volatile boolean shuttingDown;
        private Task task;
        private Thread thread;

        Poolable(ThreadGroup pGroup, int pNum) {
            this.thread = new Thread(pGroup, pGroup.getName() + "-" + pNum){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!Poolable.this.shuttingDown) {
                        Task t = Poolable.this.getTask();
                        if (t == null) {
                            try {
                                1 var2_2 = this;
                                synchronized (var2_2) {
                                    if (!Poolable.this.shuttingDown && Poolable.this.getTask() == null) {
                                        this.wait();
                                    }
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                        }
                        try {
                            t.run();
                            Poolable.this.resetTask();
                            ThreadPool.this.repool(Poolable.this);
                        }
                        catch (Throwable e) {
                            ThreadPool.this.remove(Poolable.this);
                            Poolable.this.shutdown();
                            Poolable.this.resetTask();
                        }
                    }
                }
            };
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void shutdown() {
            this.shuttingDown = true;
            Task t = this.getTask();
            if (t != null && t instanceof InterruptableTask) {
                try {
                    ((InterruptableTask)t).shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.task = null;
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }

        private Task getTask() {
            return this.task;
        }

        private void resetTask() {
            this.task = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start(Task pTask) {
            this.task = pTask;
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
        }
    }

    public static interface Task {
        public void run() throws Throwable;
    }
}

