/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.shadows;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.shadows.AbstractDropShadowBorder;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.pde.api.tools.annotations.NoReference;

@NoExtend
@NoReference
@NoInstantiate
public class RectangleDropShadowBorder
extends AbstractDropShadowBorder {
    private static final int DEFAULT_CORNER_START_DIAMETER = 4;
    private int startCornerArcSize;

    public RectangleDropShadowBorder() {
        this(4);
    }

    public RectangleDropShadowBorder(int arcSize) {
        this.startCornerArcSize = arcSize;
    }

    @Override
    protected void paintDropShadow(Graphics graphics, Rectangle shadowRect, int size) {
        int cornerRadius = this.startCornerArcSize / 2;
        int bottomXStart = shadowRect.x + cornerRadius;
        int bottomY = shadowRect.y + 1 + shadowRect.height;
        int bottomXEnd = shadowRect.x + shadowRect.width + 1 - cornerRadius;
        int rightX = shadowRect.x + shadowRect.width + 1;
        int rightYStart = shadowRect.y + cornerRadius;
        int rightYEnd = shadowRect.y + shadowRect.height + 1 - cornerRadius;
        int cornerDiameter = this.startCornerArcSize;
        int i = 0;
        while (i <= size) {
            double progress = (double)i / (double)size;
            graphics.setAlpha(this.calcAlphaValue(progress));
            graphics.drawLine(bottomXStart, bottomY, bottomXEnd, bottomY);
            graphics.drawLine(rightX, rightYStart, rightX, rightYEnd);
            graphics.drawArc(rightX - cornerDiameter, bottomY - cornerDiameter, cornerDiameter, cornerDiameter, 270, 90);
            ++bottomXStart;
            ++bottomY;
            ++rightX;
            ++rightYStart;
            cornerDiameter += 2;
            ++i;
        }
    }

    @Override
    protected void paintHalo(Graphics graphics, Rectangle shadowRect, int size) {
        Rectangle r = shadowRect.getCopy();
        int cornerArcSize = this.startCornerArcSize;
        int i = 0;
        while (i < size) {
            double progress = (double)i / (double)size;
            graphics.setAlpha(this.calcAlphaValue(progress));
            graphics.drawRoundRectangle(r, cornerArcSize, cornerArcSize);
            cornerArcSize += 2;
            r.expand(1, 1);
            ++i;
        }
    }

    public void setCornerArcSize(int cornerArcSize) {
        this.startCornerArcSize = cornerArcSize;
    }
}

