/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.view.ui.ITerminalsView;
import org.eclipse.terminal.view.ui.TerminalViewId;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.terminal.view.ui.internal.tabs.TabFolderManager;
import org.eclipse.terminal.view.ui.internal.view.TerminalsView;
import org.eclipse.terminal.view.ui.launcher.ITerminalConsoleViewManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@Component(service={ITerminalConsoleViewManager.class})
public final class ConsoleManager
implements ITerminalConsoleViewManager {
    private final IPerspectiveListener perspectiveListener = new ConsoleManagerPerspectiveListener();
    private final IPartListener2 partListener = new ConsoleManagerPartListener();
    String lastActiveViewId = null;
    String lastActiveSecondaryViewId = null;

    public void addWindowAndPerspectiveListeners(IWorkbenchWindow window) {
        if (PlatformUI.isWorkbenchRunning() && window != null) {
            window.addPerspectiveListener(this.perspectiveListener);
            IPartService service = window.getPartService();
            service.addPartListener(this.partListener);
        }
    }

    public void removeWindowAndPerspectiveListeners(IWorkbenchWindow window) {
        if (PlatformUI.isWorkbenchRunning() && window != null) {
            window.removePerspectiveListener(this.perspectiveListener);
            IPartService service = window.getPartService();
            service.removePartListener(this.partListener);
        }
    }

    private final IWorkbenchPage getActiveWorkbenchPage() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return null;
    }

    @Override
    public Optional<ITerminalsView> findConsoleView(TerminalViewId tvid) {
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        return this.findTerminalsViewWithSecondaryId(tvid, true);
    }

    private Optional<ITerminalsView> findTerminalsViewWithSecondaryId(TerminalViewId tvid, boolean restore) {
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page == null) {
            return Optional.empty();
        }
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IViewReference ref;
                block6: {
                    ref = iViewReferenceArray[n2];
                    if (!ref.getId().equals(tvid.primary())) break block5;
                    String refSecondaryId = ref.getSecondaryId();
                    String secondaryId = tvid.secondary().orElse(null);
                    if ("*".equals(secondaryId)) break block6;
                    if (!Objects.equals(secondaryId, refSecondaryId)) break block5;
                }
                return Optional.ofNullable(ref.getView(restore)).filter(ITerminalsView.class::isInstance).map(ITerminalsView.class::cast);
            }
            ++n2;
        }
        return Optional.empty();
    }

    private Optional<ITerminalsView> findActiveTerminalsView(TerminalViewId tvid) {
        String finalSecondaryId;
        Optional<ITerminalsView> part = Optional.empty();
        String id = tvid.primary();
        String secondaryId = tvid.secondary().orElse(null);
        if (id.equals(this.lastActiveViewId) && ("last".equals(secondaryId) || Objects.equals(secondaryId, this.lastActiveSecondaryViewId))) {
            part = this.findTerminalsViewWithSecondaryId(new TerminalViewId(this.lastActiveViewId, this.lastActiveSecondaryViewId), false);
        }
        if (part.isEmpty() && (part = this.findTerminalsViewWithSecondaryId(new TerminalViewId(id, finalSecondaryId = "last".equals(secondaryId) ? "*" : secondaryId), true)).isPresent()) {
            IViewSite site = part.get().getViewSite();
            this.lastActiveViewId = site.getId();
            this.lastActiveSecondaryViewId = site.getSecondaryId();
        }
        return part;
    }

    @Override
    public ITerminalsView showConsoleView(TerminalViewId tvid) throws CoreException {
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page == null) {
            throw this.noActivePage();
        }
        Optional<ITerminalsView> found = this.findActiveTerminalsView(tvid);
        if (found.isEmpty()) {
            String secondaryId = tvid.secondary().orElse(null);
            String finalSecondaryId = "last".equals(secondaryId) || "*".equals(secondaryId) ? null : secondaryId;
            found = Optional.of(page.showView(tvid.primary(), finalSecondaryId, 1)).filter(ITerminalsView.class::isInstance).map(ITerminalsView.class::cast);
        }
        found.ifPresent(arg_0 -> ((IWorkbenchPage)page).bringToTop(arg_0));
        return found.orElseThrow(this::cannotCreateConsole);
    }

    private CoreException noActivePage() {
        return new CoreException(Status.error((String)Messages.ConsoleManager_e_no_active_page));
    }

    private CoreException cannotCreateConsole() {
        return new CoreException(Status.error((String)Messages.ConsoleManager_e_cannot_create_console));
    }

    private ITerminalsView bringToTop(TerminalViewId tvid, boolean activate) throws CoreException {
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page == null) {
            throw this.noActivePage();
        }
        Optional<ITerminalsView> found = this.findActiveTerminalsView(tvid);
        if (found.isEmpty()) {
            return this.showConsoleView(new TerminalViewId(tvid.primary(), new TerminalViewId().next().secondary()));
        }
        ITerminalsView tv = found.get();
        if (activate) {
            page.activate((IWorkbenchPart)tv);
        } else {
            page.bringToTop((IWorkbenchPart)tv);
        }
        return tv;
    }

    @Override
    public Widget openConsole(TerminalViewId tvid, String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) throws CoreException {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        boolean activate = flags != null && flags.containsKey("activate") ? flags.get("activate") : false;
        boolean forceNew = flags != null && flags.containsKey("terminal.forceNew") ? flags.get("terminal.forceNew") : false;
        ITerminalsView view = this.bringToTop(tvid, activate);
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            throw this.cannotCreateConsole();
        }
        String secId = ((IViewSite)view.getSite()).getSecondaryId();
        Optional<Widget> item = this.findConsole(new TerminalViewId(tvid.primary(), secId), title, connector, data);
        view.switchToTabFolderControl();
        if (item.isEmpty() || forceNew) {
            if (UIPlugin.getScopedPreferences().getBoolean("terminals.removeTerminatedTerminals")) {
                manager.removeTerminatedItems();
                view.switchToTabFolderControl();
            }
            item = Optional.ofNullable(manager.createTabItem(title, encoding, connector, data, flags));
        }
        CTabItem tab = this.toTabItem(item);
        manager.bringToTop(tab);
        view.setFocus();
        return tab;
    }

    private CTabItem toTabItem(Optional<Widget> item) throws CoreException {
        return item.filter(CTabItem.class::isInstance).map(CTabItem.class::cast).orElseThrow(this::cannotCreateConsole);
    }

    @Override
    public Optional<Widget> findConsole(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        ITerminalsView view = this.findConsoleView(tvid).orElse(null);
        if (view == null) {
            return Optional.empty();
        }
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(manager.findTabItem(title, connector, data)).map(Widget.class::cast);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Optional<Widget> findConsole(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        item = null;
        page = this.getActiveWorkbenchPage();
        if (page != null) {
            var7_4 = page.getViewReferences();
            var6_5 = var7_4.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                ref = var7_4[var5_6];
                v0 = part = ref != null ? ref.getView(false) : null;
                if (part instanceof ITerminalsView) {
                    tabFolder = (CTabFolder)part.getAdapter(CTabFolder.class);
                    if (tabFolder != null) {
                        var14_14 = candidates = tabFolder.getItems();
                        var13_13 = candidates.length;
                        var12_12 = 0;
                        while (var12_12 < var13_13) {
                            candidate = var14_14[var12_12];
                            data = candidate.getData();
                            if (data instanceof ITerminalControl && control.equals(data)) {
                                item = candidate;
                                ** break;
                            }
                            ++var12_12;
                        }
                    }
                } else if (item != null) break;
                ++var5_6;
            }
        }
        return Optional.ofNullable(item);
    }

    private CTabItem findConsoleForTerminalConnector(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            IViewReference[] refs;
            IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item;
                TabFolderManager manager;
                IViewPart part;
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals(tvid.primary()) && (part = ref.getView(true)) instanceof ITerminalsView && (manager = (TabFolderManager)((Object)part.getAdapter(TabFolderManager.class))) != null && (item = manager.findTabItem(title, connector, data)) != null) {
                    return item;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void closeConsole(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(tvid, title, connector, data);
        if (console != null) {
            console.dispose();
        }
    }

    @Override
    public void terminateConsole(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
        ITerminalViewControl terminal;
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(tvid, title, connector, data);
        if (console != null && !console.isDisposed() && (terminal = (ITerminalViewControl)console.getData()) != null && !terminal.isDisposed()) {
            terminal.disconnectTerminal();
        }
    }

    class ConsoleManagerPartListener
    implements IPartListener2 {
        ConsoleManagerPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof ITerminalsView) {
                ConsoleManager.this.lastActiveViewId = ((ITerminalsView)part).getViewSite().getId();
                ConsoleManager.this.lastActiveSecondaryViewId = ((ITerminalsView)part).getViewSite().getSecondaryId();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    static final class ConsoleManagerPerspectiveListener
    extends PerspectiveAdapter {
        private final List<IViewReference> references = new ArrayList<IViewReference>();

        ConsoleManagerPerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (this.references.isEmpty()) {
                return;
            }
            ArrayList<IViewReference> oldReferences = new ArrayList<IViewReference>(this.references);
            ArrayList<IViewReference> references = new ArrayList<IViewReference>(Arrays.asList(page.getViewReferences()));
            for (IViewReference reference : oldReferences) {
                if (references.contains(reference)) continue;
                try {
                    page.showView(reference.getId(), reference.getSecondaryId(), 2);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.references.clear();
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                IViewPart part = reference.getView(false);
                if (part instanceof TerminalsView && !this.references.contains(reference)) {
                    this.references.add(reference);
                }
                ++n2;
            }
        }
    }
}

