/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.internal.ui.cview.DividerLine;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

public class DecoratingCOutlineLabelProvider
extends DecoratingCLabelProvider {
    private static final int MAXIMUM_REASONABLE_WIDTH = 4000;

    public DecoratingCOutlineLabelProvider(CUILabelProvider labelProvider) {
        super(labelProvider, true);
    }

    protected void measure(Event event, Object element) {
        if (!this.isOwnerDrawEnabled()) {
            return;
        }
        if (element instanceof DividerLine) {
            GC gc = event.gc;
            if (gc == null) {
                event.width = 4000;
            } else {
                Rectangle clipping = gc.getClipping();
                event.width = Math.min(clipping.width - event.x, 4000);
            }
        } else {
            super.measure(event, element);
        }
    }

    protected void paint(Event event, Object element) {
        if (!this.isOwnerDrawEnabled()) {
            return;
        }
        if (element instanceof DividerLine) {
            int y = event.y + event.height / 2;
            ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            event.gc.setForeground(new Color(colorRegistry.getRGB("org.eclipse.cdt.ui.outline.mark.dividercolor")));
            event.gc.drawLine(0, y, event.x + 4000, y);
        } else {
            super.paint(event, element);
        }
    }
}

