/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.util.stream.Stream;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class DockerComposeConsoleUtils {
    public static final String WORKING_DIR = "org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole.workingDir";
    public static final String DOCKER_CONNECTION = "org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole.dockerConnection";

    private DockerComposeConsoleUtils() {
    }

    public static DockerComposeConsole findConsole(IDockerConnection connection, String workingDir) {
        if (workingDir == null) {
            return null;
        }
        return Stream.of(ConsolePlugin.getDefault().getConsoleManager().getConsoles()).filter(c -> c.getType() != null && c.getType().equals("org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole")).map(c -> (DockerComposeConsole)((Object)c)).filter(c -> c.getAttribute(DOCKER_CONNECTION) != null && c.getAttribute(DOCKER_CONNECTION).equals(connection) && c.getAttribute(WORKING_DIR) != null && c.getAttribute(WORKING_DIR).equals(workingDir)).findFirst().orElseGet(() -> {
            DockerComposeConsole dockerComposeConsole = new DockerComposeConsole(connection, workingDir);
            dockerComposeConsole.setAttribute(DOCKER_CONNECTION, connection);
            dockerComposeConsole.setAttribute(WORKING_DIR, workingDir);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{dockerComposeConsole});
            return dockerComposeConsole;
        });
    }
}

