/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.midx.MidxIterators;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.lib.MutableObjectId;

public class PackIndexMerger {
    private static final int LIMIT_31_BITS = Integer.MAX_VALUE;
    private static final long LIMIT_32_BITS = 0xFFFFFFFFL;
    private final MultiPackIndex.MidxIterator midxIterator;
    private final boolean needsLargeOffsetsChunk;
    private final int offsetsOver31BitsCount;
    private final int uniqueObjectCount;
    private final int[] objectsPerPack;
    private final List<String> packnames;

    public static Builder builder() {
        return new Builder();
    }

    private PackIndexMerger(MultiPackIndex.MidxIterator midxIterator) {
        this.midxIterator = midxIterator;
        this.packnames = midxIterator.getPackNames();
        this.objectsPerPack = new int[this.packnames.size()];
        int objectCount = 0;
        boolean hasLargeOffsets = false;
        int over31bits = 0;
        MutableObjectId lastSeen = new MutableObjectId();
        while (midxIterator.hasNext()) {
            MultiPackIndex.MutableEntry entry = (MultiPackIndex.MutableEntry)midxIterator.next();
            if (entry.getOffset() > 0xFFFFFFFFL) {
                hasLargeOffsets = true;
            }
            if (entry.getOffset() > Integer.MAX_VALUE) {
                ++over31bits;
            }
            lastSeen.fromObjectId(entry.oid);
            ++objectCount;
            int n = entry.getPackId();
            this.objectsPerPack[n] = this.objectsPerPack[n] + 1;
        }
        this.uniqueObjectCount = objectCount;
        this.offsetsOver31BitsCount = over31bits;
        this.needsLargeOffsetsChunk = hasLargeOffsets;
    }

    int getUniqueObjectCount() {
        return this.uniqueObjectCount;
    }

    boolean needsLargeOffsetsChunk() {
        return this.needsLargeOffsetsChunk;
    }

    int getOffsetsOver31BitsCount() {
        return this.offsetsOver31BitsCount;
    }

    int[] getObjectsPerPack() {
        return this.objectsPerPack;
    }

    List<String> getPackNames() {
        return this.packnames;
    }

    int getPackCount() {
        return this.packnames.size();
    }

    MultiPackIndex.MidxIterator bySha1Iterator() {
        this.midxIterator.reset();
        return this.midxIterator;
    }

    public static class Builder {
        private final List<MultiPackIndex.MidxIterator> packIndexes = new ArrayList<MultiPackIndex.MidxIterator>();

        public Builder addPack(String name, PackIndex idx) {
            this.packIndexes.add(MidxIterators.fromPackIndexIterator(name, idx));
            return this;
        }

        public Builder addMidx(MultiPackIndex.MidxIterator midx) {
            this.packIndexes.add(midx);
            return this;
        }

        public PackIndexMerger build() {
            return new PackIndexMerger(MidxIterators.dedup(MidxIterators.join(this.packIndexes)));
        }
    }
}

