/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class PropertiesMetalTheme
extends DefaultMetalTheme {
    private String name = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;

    public PropertiesMetalTheme(InputStream stream) {
        this.initColors();
        this.loadProperties(stream);
    }

    private void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    private void loadProperties(InputStream stream) {
        Properties prop = new Properties();
        try {
            prop.load(stream);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        Object tempName = prop.get("name");
        if (tempName != null) {
            this.name = tempName.toString();
        }
        Object colorString = null;
        colorString = prop.get("primary1");
        if (colorString != null) {
            this.primary1 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("primary2")) != null) {
            this.primary2 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("primary3")) != null) {
            this.primary3 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary1")) != null) {
            this.secondary1 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary2")) != null) {
            this.secondary2 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary3")) != null) {
            this.secondary3 = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("black")) != null) {
            this.black = this.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("white")) != null) {
            this.white = this.parseColor(colorString.toString());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    private ColorUIResource parseColor(String s) {
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            red = Integer.parseInt(st.nextToken());
            green = Integer.parseInt(st.nextToken());
            blue = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Couldn't parse color :" + s);
        }
        return new ColorUIResource(red, green, blue);
    }
}

