/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.cgroup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdk.test.lib.Asserts;

public class CPUSetsReader {
    public static String PROC_SELF_STATUS_PATH = "/proc/self/status";

    public static void test() {
        CPUSetsReader.assertParse("0-7", "0,1,2,3,4,5,6,7");
        CPUSetsReader.assertParse("1,3,6", "1,3,6");
        CPUSetsReader.assertParse("0,2-4,6,10-11", "0,2,3,4,6,10,11");
        CPUSetsReader.assertParse("0", "0");
    }

    private static void assertParse(String cpuSet, String expectedResult) {
        Asserts.assertEquals(CPUSetsReader.listToString(CPUSetsReader.parseCpuSet(cpuSet)), expectedResult);
    }

    public static int getNumCpus() {
        int n;
        block8: {
            String path = "/proc/cpuinfo";
            Stream<String> stream = Files.lines(Paths.get(path, new String[0]));
            try {
                n = (int)stream.filter(line -> line.startsWith("processor")).count();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return 0;
                }
            }
            stream.close();
        }
        return n;
    }

    public static String readFromProcStatus(String setType) {
        String path = PROC_SELF_STATUS_PATH;
        Optional<Object> o = Optional.empty();
        System.out.println("readFromProcStatus() entering for: " + setType);
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            o = stream.filter(line -> line.contains(setType)).findFirst();
        }
        catch (IOException e) {
            return null;
        }
        if (!o.isPresent()) {
            return null;
        }
        String[] parts = ((String)o.get()).replaceAll("\\s", "").split(":");
        Asserts.assertEquals(parts.length, 2);
        String result = parts[1];
        System.out.println("readFromProcStatus() returning: " + result);
        return result;
    }

    public static List<Integer> parseCpuSet(String value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            String[] commaSeparated;
            for (String item : commaSeparated = value.split(",")) {
                if (item.contains("-")) {
                    CPUSetsReader.addRange(result, item);
                    continue;
                }
                result.add(Integer.parseInt(item));
            }
        }
        catch (Exception e) {
            System.err.println("Exception in getMaxCpuSets(): " + String.valueOf(e));
            return null;
        }
        return result;
    }

    private static void addRange(ArrayList<Integer> list, String s) {
        int max;
        String[] range = s.split("-");
        if (range.length != 2) {
            throw new RuntimeException("Range should only contain two items, but contains " + range.length + " items");
        }
        int min = Integer.parseInt(range[0]);
        if (min >= (max = Integer.parseInt(range[1]))) {
            String msg = String.format("min is greater or equals to max, min = %d, max = %d", min, max);
            throw new RuntimeException(msg);
        }
        for (int i = min; i <= max; ++i) {
            list.add(i);
        }
    }

    public static String listToString(List<Integer> list) {
        return CPUSetsReader.listToString(list, Integer.MAX_VALUE);
    }

    public static String listToString(List<Integer> list, int maxCount) {
        return list.stream().limit(maxCount).map(Object::toString).collect(Collectors.joining(","));
    }

    public static String numberToString(int num) {
        return IntStream.range(0, num).boxed().map(Object::toString).collect(Collectors.joining(","));
    }
}

