/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.model.StackFrame;

public class StackTrace {
    private StackFrame[] frames;

    public StackTrace(StackFrame[] frames) {
        this.frames = frames;
    }

    public StackTrace traceForDepth(int depth) {
        if (depth >= this.frames.length) {
            return this;
        }
        StackFrame[] f = new StackFrame[depth];
        System.arraycopy(this.frames, 0, f, 0, depth);
        return new StackTrace(f);
    }

    public void resolve(Snapshot snapshot) {
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i].resolve(snapshot);
        }
    }

    public StackFrame[] getFrames() {
        return this.frames;
    }
}

