/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FileChooserDemo
extends JPanel
implements ActionListener {
    public static final String NIMBUS_LAF_NAME = "Nimbus";
    private static JFrame frame;
    private final List<SupportedLaF> supportedLaFs = new ArrayList<SupportedLaF>();
    private static SupportedLaF nimbusLaF;
    private JButton showButton;
    private JCheckBox showAllFilesFilterCheckBox;
    private JCheckBox showImageFilesFilterCheckBox;
    private JCheckBox showFullDescriptionCheckBox;
    private JCheckBox useFileViewCheckBox;
    private JCheckBox useFileSystemViewCheckBox;
    private JCheckBox accessoryCheckBox;
    private JCheckBox setHiddenCheckBox;
    private JCheckBox useEmbedInWizardCheckBox;
    private JCheckBox useControlsCheckBox;
    private JCheckBox enableDragCheckBox;
    private JRadioButton singleSelectionRadioButton;
    private JRadioButton multiSelectionRadioButton;
    private JRadioButton openRadioButton;
    private JRadioButton saveRadioButton;
    private JRadioButton customButton;
    private JComboBox<SupportedLaF> lafComboBox;
    private JRadioButton justFilesRadioButton;
    private JRadioButton justDirectoriesRadioButton;
    private JRadioButton bothFilesAndDirectoriesRadioButton;
    private JTextField customField;
    private final ExampleFileView fileView;
    private final ExampleFileSystemView fileSystemView;
    private static final Dimension hpad10;
    private static final Dimension vpad20;
    private static final Dimension vpad7;
    private static final Dimension vpad4;
    private static final Insets insets;
    private final FilePreviewer previewer;
    private final JFileChooser chooser;

    public FileChooserDemo() {
        UIManager.LookAndFeelInfo[] installedLafs;
        for (UIManager.LookAndFeelInfo lafInfo : installedLafs = UIManager.getInstalledLookAndFeels()) {
            try {
                Class<?> lnfClass = Class.forName(lafInfo.getClassName());
                LookAndFeel laf = (LookAndFeel)lnfClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!laf.isSupportedLookAndFeel()) continue;
                String name = lafInfo.getName();
                SupportedLaF supportedLaF = new SupportedLaF(name, laf);
                this.supportedLaFs.add(supportedLaF);
                if (!NIMBUS_LAF_NAME.equals(name)) continue;
                nimbusLaF = supportedLaF;
            }
            catch (Exception lnfClass) {
                // empty catch block
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.chooser = new JFileChooser();
        this.previewer = new FilePreviewer(this, this.chooser);
        this.fileView = new ExampleFileView();
        this.fileView.putIcon("jpg", new ImageIcon(this.getClass().getResource("/resources/images/jpgIcon.jpg")));
        this.fileView.putIcon("gif", new ImageIcon(this.getClass().getResource("/resources/images/gifIcon.gif")));
        this.fileSystemView = new ExampleFileSystemView();
        OptionListener optionListener = new OptionListener(this);
        this.openRadioButton = new JRadioButton("Open");
        this.openRadioButton.setSelected(true);
        this.openRadioButton.addActionListener(optionListener);
        this.saveRadioButton = new JRadioButton("Save");
        this.saveRadioButton.addActionListener(optionListener);
        this.customButton = new JRadioButton("Custom");
        this.customButton.addActionListener(optionListener);
        this.customField = new JTextField(this, 8){
            final /* synthetic */ FileChooserDemo this$0;
            {
                FileChooserDemo fileChooserDemo = this$0;
                Objects.requireNonNull(fileChooserDemo);
                this.this$0 = fileChooserDemo;
                super(arg0);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width, this.getPreferredSize().height);
            }
        };
        this.customField.setText("Doit");
        this.customField.setAlignmentY(0.0f);
        this.customField.setEnabled(false);
        this.customField.addActionListener(optionListener);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.openRadioButton);
        group1.add(this.saveRadioButton);
        group1.add(this.customButton);
        this.showAllFilesFilterCheckBox = new JCheckBox("Show \"All Files\" Filter");
        this.showAllFilesFilterCheckBox.addActionListener(optionListener);
        this.showAllFilesFilterCheckBox.setSelected(true);
        this.showImageFilesFilterCheckBox = new JCheckBox("Show JPG and GIF Filters");
        this.showImageFilesFilterCheckBox.addActionListener(optionListener);
        this.showImageFilesFilterCheckBox.setSelected(false);
        this.accessoryCheckBox = new JCheckBox("Show Preview");
        this.accessoryCheckBox.addActionListener(optionListener);
        this.accessoryCheckBox.setSelected(false);
        this.setHiddenCheckBox = new JCheckBox("Show Hidden Files");
        this.setHiddenCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox = new JCheckBox("With File Extensions");
        this.showFullDescriptionCheckBox.addActionListener(optionListener);
        this.showFullDescriptionCheckBox.setSelected(true);
        this.showFullDescriptionCheckBox.setEnabled(false);
        this.useFileViewCheckBox = new JCheckBox("Use FileView");
        this.useFileViewCheckBox.addActionListener(optionListener);
        this.useFileViewCheckBox.setSelected(false);
        this.useFileSystemViewCheckBox = new JCheckBox("Use FileSystemView", false);
        this.useFileSystemViewCheckBox.addActionListener(optionListener);
        this.useEmbedInWizardCheckBox = new JCheckBox("Embed in Wizard");
        this.useEmbedInWizardCheckBox.addActionListener(optionListener);
        this.useEmbedInWizardCheckBox.setSelected(false);
        this.useControlsCheckBox = new JCheckBox("Show Control Buttons");
        this.useControlsCheckBox.addActionListener(optionListener);
        this.useControlsCheckBox.setSelected(true);
        this.enableDragCheckBox = new JCheckBox("Enable Dragging");
        this.enableDragCheckBox.addActionListener(optionListener);
        ButtonGroup group3 = new ButtonGroup();
        this.justFilesRadioButton = new JRadioButton("Just Select Files");
        this.justFilesRadioButton.setSelected(true);
        group3.add(this.justFilesRadioButton);
        this.justFilesRadioButton.addActionListener(optionListener);
        this.justDirectoriesRadioButton = new JRadioButton("Just Select Directories");
        group3.add(this.justDirectoriesRadioButton);
        this.justDirectoriesRadioButton.addActionListener(optionListener);
        this.bothFilesAndDirectoriesRadioButton = new JRadioButton("Select Files or Directories");
        group3.add(this.bothFilesAndDirectoriesRadioButton);
        this.bothFilesAndDirectoriesRadioButton.addActionListener(optionListener);
        this.singleSelectionRadioButton = new JRadioButton("Single Selection", true);
        this.singleSelectionRadioButton.addActionListener(optionListener);
        this.multiSelectionRadioButton = new JRadioButton("Multi Selection");
        this.multiSelectionRadioButton.addActionListener(optionListener);
        ButtonGroup group4 = new ButtonGroup();
        group4.add(this.singleSelectionRadioButton);
        group4.add(this.multiSelectionRadioButton);
        this.showButton = new JButton("Show FileChooser");
        this.showButton.addActionListener(this);
        this.showButton.setMnemonic('s');
        this.lafComboBox = new JComboBox<SupportedLaF>(this.supportedLaFs.toArray(new SupportedLaF[0]));
        this.lafComboBox.setSelectedItem(nimbusLaF);
        this.lafComboBox.setEditable(false);
        this.lafComboBox.addActionListener(optionListener);
        InsetPanel control1 = new InsetPanel(insets);
        control1.setBorder(BorderFactory.createTitledBorder("Dialog Type"));
        control1.setLayout(new BoxLayout(control1, 1));
        control1.add(Box.createRigidArea(vpad20));
        control1.add(this.openRadioButton);
        control1.add(Box.createRigidArea(vpad7));
        control1.add(this.saveRadioButton);
        control1.add(Box.createRigidArea(vpad7));
        control1.add(this.customButton);
        control1.add(Box.createRigidArea(vpad4));
        JPanel fieldWrapper = new JPanel();
        fieldWrapper.setLayout(new BoxLayout(fieldWrapper, 0));
        fieldWrapper.setAlignmentX(0.0f);
        fieldWrapper.add(Box.createRigidArea(hpad10));
        fieldWrapper.add(Box.createRigidArea(hpad10));
        fieldWrapper.add(this.customField);
        control1.add(fieldWrapper);
        control1.add(Box.createRigidArea(vpad20));
        control1.add(Box.createGlue());
        InsetPanel control2 = new InsetPanel(insets);
        control2.setBorder(BorderFactory.createTitledBorder("Filter Controls"));
        control2.setLayout(new BoxLayout(control2, 1));
        control2.add(Box.createRigidArea(vpad20));
        control2.add(this.showAllFilesFilterCheckBox);
        control2.add(Box.createRigidArea(vpad7));
        control2.add(this.showImageFilesFilterCheckBox);
        control2.add(Box.createRigidArea(vpad4));
        JPanel checkWrapper = new JPanel();
        checkWrapper.setLayout(new BoxLayout(checkWrapper, 0));
        checkWrapper.setAlignmentX(0.0f);
        checkWrapper.add(Box.createRigidArea(hpad10));
        checkWrapper.add(Box.createRigidArea(hpad10));
        checkWrapper.add(this.showFullDescriptionCheckBox);
        control2.add(checkWrapper);
        control2.add(Box.createRigidArea(vpad20));
        control2.add(Box.createGlue());
        InsetPanel control3 = new InsetPanel(insets);
        control3.setBorder(BorderFactory.createTitledBorder("Display Options"));
        control3.setLayout(new BoxLayout(control3, 1));
        control3.add(Box.createRigidArea(vpad20));
        control3.add(this.setHiddenCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.useFileViewCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.useFileSystemViewCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.accessoryCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.useEmbedInWizardCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.useControlsCheckBox);
        control3.add(Box.createRigidArea(vpad7));
        control3.add(this.enableDragCheckBox);
        control3.add(Box.createRigidArea(vpad20));
        control3.add(Box.createGlue());
        InsetPanel control4 = new InsetPanel(insets);
        control4.setBorder(BorderFactory.createTitledBorder("File and Directory Options"));
        control4.setLayout(new BoxLayout(control4, 1));
        control4.add(Box.createRigidArea(vpad20));
        control4.add(this.justFilesRadioButton);
        control4.add(Box.createRigidArea(vpad7));
        control4.add(this.justDirectoriesRadioButton);
        control4.add(Box.createRigidArea(vpad7));
        control4.add(this.bothFilesAndDirectoriesRadioButton);
        control4.add(Box.createRigidArea(vpad20));
        control4.add(this.singleSelectionRadioButton);
        control4.add(Box.createRigidArea(vpad7));
        control4.add(this.multiSelectionRadioButton);
        control4.add(Box.createRigidArea(vpad20));
        control4.add(Box.createGlue());
        JPanel panel = new JPanel();
        panel.add(new JLabel("Look and Feel: "));
        panel.add(this.lafComboBox);
        panel.add(this.showButton);
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 0));
        this.add(Box.createRigidArea(vpad20));
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(control1);
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(control2);
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(control3);
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(control4);
        wrapper.add(Box.createRigidArea(hpad10));
        wrapper.add(Box.createRigidArea(hpad10));
        this.add(wrapper);
        this.add(Box.createRigidArea(vpad20));
        this.add(panel);
        this.add(Box.createRigidArea(vpad20));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.customButton.isSelected()) {
            this.chooser.setApproveButtonText(this.customField.getText());
        }
        if (this.chooser.isMultiSelectionEnabled()) {
            this.chooser.setSelectedFiles(null);
        } else {
            this.chooser.setSelectedFile(null);
        }
        JComponent accessory = this.chooser.getAccessory();
        if (accessory != null) {
            ((FilePreviewer)accessory).loadImage(null);
        }
        if (this.useEmbedInWizardCheckBox.isSelected()) {
            WizardDialog wizard = new WizardDialog(this, frame, true);
            wizard.setVisible(true);
            wizard.dispose();
            return;
        }
        int retval = this.chooser.showDialog(frame, null);
        if (retval == 0) {
            JOptionPane.showMessageDialog(frame, this.getResultString());
        } else if (retval == 1) {
            JOptionPane.showMessageDialog(frame, "User cancelled operation. No file was chosen.");
        } else if (retval == -1) {
            JOptionPane.showMessageDialog(frame, "An error occurred. No file was chosen.");
        } else {
            JOptionPane.showMessageDialog(frame, "Unknown operation occurred.");
        }
    }

    private void resetFileFilters(boolean enableFilters, boolean showExtensionInDescription) {
        this.chooser.resetChoosableFileFilters();
        if (enableFilters) {
            FileFilter jpgFilter = this.createFileFilter("JPEG Compressed Image Files", showExtensionInDescription, "jpg");
            FileFilter gifFilter = this.createFileFilter("GIF Image Files", showExtensionInDescription, "gif");
            FileFilter bothFilter = this.createFileFilter("JPEG and GIF Image Files", showExtensionInDescription, "jpg", "gif");
            this.chooser.addChoosableFileFilter(bothFilter);
            this.chooser.addChoosableFileFilter(jpgFilter);
            this.chooser.addChoosableFileFilter(gifFilter);
        }
    }

    private FileFilter createFileFilter(String description, boolean showExtensionInDescription, String ... extensions) {
        if (showExtensionInDescription) {
            description = this.createFileNameFilterDescriptionFromExtensions(description, extensions);
        }
        return new FileNameExtensionFilter(description, extensions);
    }

    private String createFileNameFilterDescriptionFromExtensions(String description, String[] extensions) {
        Object fullDescription = description == null ? "(" : description + " (";
        fullDescription = (String)fullDescription + "." + extensions[0];
        for (int i = 1; i < extensions.length; ++i) {
            fullDescription = (String)fullDescription + ", .";
            fullDescription = (String)fullDescription + extensions[i];
        }
        fullDescription = (String)fullDescription + ")";
        return fullDescription;
    }

    private String getResultString() {
        Object resultString;
        String filter = this.chooser.getFileFilter() == null ? "" : this.chooser.getFileFilter().getDescription();
        Object path = null;
        boolean isDirMode = this.chooser.getFileSelectionMode() == 1;
        boolean isMulti = this.chooser.isMultiSelectionEnabled();
        if (isMulti) {
            File[] files = this.chooser.getSelectedFiles();
            if (files != null && files.length > 0) {
                path = "";
                for (File file : files) {
                    path = (String)path + "<br>" + file.getPath();
                }
            }
        } else {
            File file = this.chooser.getSelectedFile();
            if (file != null) {
                path = "<br>" + file.getPath();
            }
        }
        if (path != null) {
            path = ((String)path).replace(" ", "&nbsp;");
            filter = filter.replace(" ", "&nbsp;");
            resultString = "<html>You chose " + (isMulti ? "these" : "this") + " " + (isDirMode ? (isMulti ? "directories" : "directory") : (isMulti ? "files" : "file")) + ": <code>" + (String)path + "</code><br><br>with filter: <br><code>" + filter;
        } else {
            resultString = "Nothing was chosen";
        }
        return resultString;
    }

    public static void main(String[] s) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!FileChooserDemo.NIMBUS_LAF_NAME.equals(info.getName())) continue;
                            UIManager.setLookAndFeel(info.getClassName());
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FileChooserDemo panel = new FileChooserDemo();
                    frame = new JFrame("FileChooserDemo");
                    frame.setDefaultCloseOperation(3);
                    frame.getContentPane().add("Center", panel);
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FileChooserDemo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(FileChooserDemo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        hpad10 = new Dimension(10, 1);
        vpad20 = new Dimension(1, 20);
        vpad7 = new Dimension(1, 7);
        vpad4 = new Dimension(1, 4);
        insets = new Insets(5, 10, 0, 10);
    }

    private static class SupportedLaF {
        private final String name;
        private final LookAndFeel laf;

        SupportedLaF(String name, LookAndFeel laf) {
            this.name = name;
            this.laf = laf;
        }

        public String toString() {
            return this.name;
        }
    }

    private class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail;
        final /* synthetic */ FileChooserDemo this$0;

        public FilePreviewer(FileChooserDemo fileChooserDemo, JFileChooser fc) {
            FileChooserDemo fileChooserDemo2 = fileChooserDemo;
            Objects.requireNonNull(fileChooserDemo2);
            this.this$0 = fileChooserDemo2;
            this.thumbnail = null;
            this.setPreferredSize(new Dimension(100, 50));
            fc.addPropertyChangeListener(this);
        }

        public void loadImage(File f) {
            ImageIcon tmpIcon;
            this.thumbnail = f == null ? null : ((tmpIcon = new ImageIcon(f.getPath())).getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("SelectedFileChangedProperty".equals(prop) && this.isShowing()) {
                this.loadImage((File)e.getNewValue());
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            if (this.thumbnail != null) {
                int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.thumbnail.paintIcon(this, g, x, y);
            }
        }
    }

    private class OptionListener
    implements ActionListener {
        final /* synthetic */ FileChooserDemo this$0;

        private OptionListener(FileChooserDemo fileChooserDemo) {
            FileChooserDemo fileChooserDemo2 = fileChooserDemo;
            Objects.requireNonNull(fileChooserDemo2);
            this.this$0 = fileChooserDemo2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent c = (JComponent)e.getSource();
            boolean selected = false;
            if (c instanceof JToggleButton) {
                selected = ((JToggleButton)c).isSelected();
            }
            if (c == this.this$0.openRadioButton) {
                this.this$0.chooser.setDialogType(0);
                this.this$0.customField.setEnabled(false);
                this.this$0.repaint();
            } else if (c == this.this$0.useEmbedInWizardCheckBox) {
                this.this$0.useControlsCheckBox.setEnabled(!selected);
                this.this$0.useControlsCheckBox.setSelected(!selected);
                this.this$0.chooser.setControlButtonsAreShown(!selected);
            } else if (c == this.this$0.useControlsCheckBox) {
                this.this$0.chooser.setControlButtonsAreShown(selected);
            } else if (c == this.this$0.enableDragCheckBox) {
                this.this$0.chooser.setDragEnabled(selected);
            } else if (c == this.this$0.saveRadioButton) {
                this.this$0.chooser.setDialogType(1);
                this.this$0.customField.setEnabled(false);
                this.this$0.repaint();
            } else if (c == this.this$0.customButton || c == this.this$0.customField) {
                this.this$0.customField.setEnabled(true);
                this.this$0.chooser.setDialogType(2);
                this.this$0.repaint();
            } else if (c == this.this$0.showAllFilesFilterCheckBox) {
                this.this$0.chooser.setAcceptAllFileFilterUsed(selected);
            } else if (c == this.this$0.showImageFilesFilterCheckBox) {
                this.this$0.resetFileFilters(selected, this.this$0.showFullDescriptionCheckBox.isSelected());
                this.this$0.showFullDescriptionCheckBox.setEnabled(selected);
            } else if (c == this.this$0.setHiddenCheckBox) {
                this.this$0.chooser.setFileHidingEnabled(!selected);
            } else if (c == this.this$0.accessoryCheckBox) {
                if (selected) {
                    this.this$0.chooser.setAccessory(this.this$0.previewer);
                } else {
                    this.this$0.chooser.setAccessory(null);
                }
            } else if (c == this.this$0.useFileViewCheckBox) {
                if (selected) {
                    this.this$0.chooser.setFileView(this.this$0.fileView);
                } else {
                    this.this$0.chooser.setFileView(null);
                }
            } else if (c == this.this$0.useFileSystemViewCheckBox) {
                if (selected) {
                    this.this$0.chooser.setFileSystemView(this.this$0.fileSystemView);
                } else {
                    this.this$0.chooser.setFileSystemView(FileSystemView.getFileSystemView());
                }
            } else if (c == this.this$0.showFullDescriptionCheckBox) {
                this.this$0.resetFileFilters(this.this$0.showImageFilesFilterCheckBox.isSelected(), selected);
            } else if (c == this.this$0.justFilesRadioButton) {
                this.this$0.chooser.setFileSelectionMode(0);
            } else if (c == this.this$0.justDirectoriesRadioButton) {
                this.this$0.chooser.setFileSelectionMode(1);
            } else if (c == this.this$0.bothFilesAndDirectoriesRadioButton) {
                this.this$0.chooser.setFileSelectionMode(2);
            } else if (c == this.this$0.singleSelectionRadioButton) {
                if (selected) {
                    this.this$0.chooser.setMultiSelectionEnabled(false);
                }
            } else if (c == this.this$0.multiSelectionRadioButton) {
                if (selected) {
                    this.this$0.chooser.setMultiSelectionEnabled(true);
                }
            } else if (c == this.this$0.lafComboBox) {
                SupportedLaF supportedLaF = (SupportedLaF)this.this$0.lafComboBox.getSelectedItem();
                LookAndFeel laf = supportedLaF.laf;
                try {
                    UIManager.setLookAndFeel(laf);
                    SwingUtilities.updateComponentTreeUI(frame);
                    if (this.this$0.chooser != null) {
                        SwingUtilities.updateComponentTreeUI(this.this$0.chooser);
                    }
                    frame.pack();
                }
                catch (UnsupportedLookAndFeelException exc) {
                    ((DefaultComboBoxModel)this.this$0.lafComboBox.getModel()).removeElement(supportedLaF);
                }
            }
        }
    }

    private static class InsetPanel
    extends JPanel {
        Insets i;

        InsetPanel(Insets i) {
            this.i = i;
        }

        @Override
        public Insets getInsets() {
            return this.i;
        }
    }

    private class WizardDialog
    extends JDialog
    implements ActionListener {
        CardLayout cardLayout;
        JPanel cardPanel;
        JLabel messageLabel;
        JButton backButton;
        JButton nextButton;
        JButton closeButton;
        final /* synthetic */ FileChooserDemo this$0;

        WizardDialog(FileChooserDemo fileChooserDemo, JFrame frame, boolean modal) {
            FileChooserDemo fileChooserDemo2 = fileChooserDemo;
            Objects.requireNonNull(fileChooserDemo2);
            this.this$0 = fileChooserDemo2;
            super(frame, "Embedded JFileChooser Demo", modal);
            this.cardLayout = new CardLayout();
            this.cardPanel = new JPanel(this.cardLayout);
            this.getContentPane().add((Component)this.cardPanel, "Center");
            this.messageLabel = new JLabel("", 0);
            this.cardPanel.add((Component)fileChooserDemo.chooser, "fileChooser");
            this.cardPanel.add((Component)this.messageLabel, "label");
            this.cardLayout.show(this.cardPanel, "fileChooser");
            fileChooserDemo.chooser.addActionListener(this);
            JPanel buttonPanel = new JPanel();
            this.backButton = new JButton("< Back");
            this.nextButton = new JButton("Next >");
            this.closeButton = new JButton("Close");
            buttonPanel.add(this.backButton);
            buttonPanel.add(this.nextButton);
            buttonPanel.add(this.closeButton);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.backButton.setEnabled(false);
            this.getRootPane().setDefaultButton(this.nextButton);
            this.backButton.addActionListener(this);
            this.nextButton.addActionListener(this);
            this.closeButton.addActionListener(this);
            this.pack();
            this.setLocationRelativeTo(frame);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            String cmd = evt.getActionCommand();
            if (src == this.backButton) {
                this.back();
            } else if (src == this.nextButton) {
                FileChooserUI ui = this.this$0.chooser.getUI();
                if (ui instanceof BasicFileChooserUI) {
                    ((BasicFileChooserUI)ui).getApproveSelectionAction().actionPerformed(null);
                } else {
                    this.next();
                }
            } else if (src == this.closeButton) {
                this.close();
            } else if ("ApproveSelection".equals(cmd)) {
                this.next();
            } else if ("CancelSelection".equals(cmd)) {
                this.close();
            }
        }

        private void back() {
            this.backButton.setEnabled(false);
            this.nextButton.setEnabled(true);
            this.cardLayout.show(this.cardPanel, "fileChooser");
            this.getRootPane().setDefaultButton(this.nextButton);
            this.this$0.chooser.requestFocus();
        }

        private void next() {
            this.backButton.setEnabled(true);
            this.nextButton.setEnabled(false);
            this.messageLabel.setText(this.this$0.getResultString());
            this.cardLayout.show(this.cardPanel, "label");
            this.getRootPane().setDefaultButton(this.closeButton);
            this.closeButton.requestFocus();
        }

        private void close() {
            this.setVisible(false);
        }

        @Override
        public void dispose() {
            this.this$0.chooser.removeActionListener(this);
            this.cardPanel.remove(this.this$0.chooser);
            this.this$0.chooser.setVisible(true);
            super.dispose();
        }
    }
}

