/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import sun.awt.AppContext;

public class WindowsToggleButtonUI
extends BasicToggleButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private static final Object WINDOWS_TOGGLE_BUTTON_UI_KEY = new Object();
    private boolean defaults_initialized = false;
    private transient Color cachedSelectedColor = null;
    private transient Color cachedBackgroundColor = null;
    private transient Color cachedHighlightColor = null;

    public static ComponentUI createUI(JComponent jComponent) {
        AppContext appContext = AppContext.getAppContext();
        WindowsToggleButtonUI windowsToggleButtonUI = (WindowsToggleButtonUI)appContext.get(WINDOWS_TOGGLE_BUTTON_UI_KEY);
        if (windowsToggleButtonUI == null) {
            windowsToggleButtonUI = new WindowsToggleButtonUI();
            appContext.put(WINDOWS_TOGGLE_BUTTON_UI_KEY, windowsToggleButtonUI);
        }
        return windowsToggleButtonUI;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            this.dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            this.dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            this.dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor((String)object + "focus");
            this.defaults_initialized = true;
        }
        if ((object = XPStyle.getXP()) != null) {
            abstractButton.setBorder(((XPStyle)object).getBorder(abstractButton, WindowsButtonUI.getXPButtonType(abstractButton)));
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (XPStyle.getXP() == null && abstractButton.isContentAreaFilled()) {
            Color color = graphics.getColor();
            Color color2 = abstractButton.getBackground();
            Color color3 = UIManager.getColor("ToggleButton.highlight");
            if (color2 != this.cachedBackgroundColor || color3 != this.cachedHighlightColor) {
                int n = color2.getRed();
                int n2 = color3.getRed();
                int n3 = color2.getGreen();
                int n4 = color3.getGreen();
                int n5 = color2.getBlue();
                int n6 = color3.getBlue();
                this.cachedSelectedColor = new Color(Math.min(n, n2) + Math.abs(n - n2) / 2, Math.min(n3, n4) + Math.abs(n3 - n4) / 2, Math.min(n5, n6) + Math.abs(n5 - n6) / 2);
                this.cachedBackgroundColor = color2;
                this.cachedHighlightColor = color3;
            }
            graphics.setColor(this.cachedSelectedColor);
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            graphics.setColor(color);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, abstractButton.getWidth() - this.dashedRectGapWidth, abstractButton.getHeight() - this.dashedRectGapHeight);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }
}

