/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

public final class ArrayCache
implements MarlinConst {
    static final int BUCKETS = 4;
    static final int MIN_ARRAY_SIZE = 4096;
    static final int MAX_ARRAY_SIZE;
    static final int MASK_CLR_1 = -2;
    static final int THRESHOLD_ARRAY_SIZE;
    static final int[] ARRAY_SIZES;
    static final int MIN_DIRTY_BYTE_ARRAY_SIZE = 65536;
    static final int MAX_DIRTY_BYTE_ARRAY_SIZE;
    static final int[] DIRTY_BYTE_ARRAY_SIZES;
    static final long THRESHOLD_LARGE_ARRAY_SIZE;
    static final long THRESHOLD_HUGE_ARRAY_SIZE;
    private static int resizeInt;
    private static int resizeDirtyInt;
    private static int resizeDirtyFloat;
    private static int resizeDirtyByte;
    private static int oversize;

    private ArrayCache() {
    }

    static synchronized void incResizeInt() {
        ++resizeInt;
    }

    static synchronized void incResizeDirtyInt() {
        ++resizeDirtyInt;
    }

    static synchronized void incResizeDirtyFloat() {
        ++resizeDirtyFloat;
    }

    static synchronized void incResizeDirtyByte() {
        ++resizeDirtyByte;
    }

    static synchronized void incOversize() {
        ++oversize;
    }

    static void dumpStats() {
        if (resizeInt != 0 || resizeDirtyInt != 0 || resizeDirtyFloat != 0 || resizeDirtyByte != 0 || oversize != 0) {
            MarlinUtils.logInfo("ArrayCache: int resize: " + resizeInt + " - dirty int resize: " + resizeDirtyInt + " - dirty float resize: " + resizeDirtyFloat + " - dirty byte resize: " + resizeDirtyByte + " - oversize: " + oversize);
        }
    }

    static int getBucket(int n) {
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            if (n > ARRAY_SIZES[i]) continue;
            return i;
        }
        return -1;
    }

    static int getBucketDirtyBytes(int n) {
        for (int i = 0; i < DIRTY_BYTE_ARRAY_SIZES.length; ++i) {
            if (n > DIRTY_BYTE_ARRAY_SIZES[i]) continue;
            return i;
        }
        return -1;
    }

    public static int getNewSize(int n, int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (n >= 0);
        int n3 = n & 0xFFFFFFFE;
        int n4 = n3 > THRESHOLD_ARRAY_SIZE ? n3 + (n3 >> 1) : n3 << 1;
        if (n4 < n2) {
            n4 = (n2 >> 12) + 1 << 12;
        }
        if (n4 < 0) {
            n4 = Integer.MAX_VALUE;
        }
        return n4;
    }

    public static long getNewLargeSize(long l, long l2) {
        if (l2 >> 31 != 0L) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (l >= 0L);
        long l3 = l > THRESHOLD_HUGE_ARRAY_SIZE ? l + (l >> 2) : (l > THRESHOLD_LARGE_ARRAY_SIZE ? l + (l >> 1) : l << 1);
        if (l3 < l2) {
            l3 = (l2 >> 12) + 1L << 12;
        }
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        return l3;
    }

    static {
        ARRAY_SIZES = new int[4];
        DIRTY_BYTE_ARRAY_SIZES = new int[4];
        resizeInt = 0;
        resizeDirtyInt = 0;
        resizeDirtyFloat = 0;
        resizeDirtyByte = 0;
        oversize = 0;
        int n = 4096;
        int n2 = 0;
        while (n2 < 4) {
            ArrayCache.ARRAY_SIZES[n2] = n;
            if (doTrace) {
                MarlinUtils.logInfo("arraySize[" + n2 + "]: " + n);
            }
            ++n2;
            n <<= 2;
        }
        MAX_ARRAY_SIZE = n >> 2;
        n = 65536;
        n2 = 0;
        while (n2 < 4) {
            ArrayCache.DIRTY_BYTE_ARRAY_SIZES[n2] = n;
            if (doTrace) {
                MarlinUtils.logInfo("dirty arraySize[" + n2 + "]: " + n);
            }
            ++n2;
            n <<= 1;
        }
        MAX_DIRTY_BYTE_ARRAY_SIZE = n >> 1;
        THRESHOLD_ARRAY_SIZE = Math.max(0x200000, MAX_ARRAY_SIZE);
        THRESHOLD_LARGE_ARRAY_SIZE = 8L * (long)THRESHOLD_ARRAY_SIZE;
        THRESHOLD_HUGE_ARRAY_SIZE = 8L * THRESHOLD_LARGE_ARRAY_SIZE;
        if (doStats) {
            MarlinUtils.logInfo("ArrayCache.BUCKETS        = 4");
            MarlinUtils.logInfo("ArrayCache.MIN_ARRAY_SIZE = 4096");
            MarlinUtils.logInfo("ArrayCache.MAX_ARRAY_SIZE = " + MAX_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.MIN_DIRTY_BYTE_ARRAY_SIZE = 65536");
            MarlinUtils.logInfo("ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE = " + MAX_DIRTY_BYTE_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(DIRTY_BYTE_ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_ARRAY_SIZE = " + THRESHOLD_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_LARGE_ARRAY_SIZE = " + THRESHOLD_LARGE_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_HUGE_ARRAY_SIZE = " + THRESHOLD_HUGE_ARRAY_SIZE);
        }
    }
}

