/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.StackValue;
import sun.jvm.hotspot.runtime.VM;

public class StackValueCollection {
    private List list;

    public StackValueCollection() {
        this.list = new ArrayList();
    }

    public StackValueCollection(int length) {
        this.list = new ArrayList(length);
    }

    public void add(StackValue val) {
        this.list.add(val);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public StackValue get(int i) {
        return (StackValue)this.list.get(i);
    }

    public boolean booleanAt(int slot) {
        return (int)this.get(slot).getInteger() != 0;
    }

    public byte byteAt(int slot) {
        return (byte)this.get(slot).getInteger();
    }

    public char charAt(int slot) {
        return (char)this.get(slot).getInteger();
    }

    public short shortAt(int slot) {
        return (short)this.get(slot).getInteger();
    }

    public int intAt(int slot) {
        return (int)this.get(slot).getInteger();
    }

    public long longAt(int slot) {
        return VM.getVM().buildLongFromIntsPD((int)this.get(slot).getInteger(), (int)this.get(slot + 1).getInteger());
    }

    public OopHandle oopHandleAt(int slot) {
        return this.get(slot).getObject();
    }

    public float floatAt(int slot) {
        return Float.intBitsToFloat(this.intAt(slot));
    }

    public double doubleAt(int slot) {
        return Double.longBitsToDouble(this.longAt(slot));
    }
}

